/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.export.GenericElementJsonHandler;
import net.sf.jasperreports.engine.export.JsonExporterContext;
import net.sf.jasperreports.util.JacksonUtil;
import net.sf.jasperreports.web.util.VelocityUtil;

public class MapElementJsonHandler
implements GenericElementJsonHandler {
    private static final MapElementJsonHandler INSTANCE = new MapElementJsonHandler();
    private static final String MAP_ELEMENT_JSON_TEMPLATE = "net/sf/jasperreports/components/map/resources/templates/MapElementJsonTemplate.vm";

    public static MapElementJsonHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public String getJsonFragment(JsonExporterContext context, JRGenericPrintElement element) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("mapCanvasId", "map_canvas_" + element.hashCode());
        Float latitude = (Float)element.getParameterValue("latitude");
        latitude = latitude == null ? MapComponent.DEFAULT_LATITUDE : latitude;
        Float longitude = (Float)element.getParameterValue("longitude");
        longitude = longitude == null ? MapComponent.DEFAULT_LONGITUDE : longitude;
        Integer zoom = (Integer)element.getParameterValue("zoom");
        zoom = zoom == null ? MapComponent.DEFAULT_ZOOM : zoom;
        String mapType = (String)element.getParameterValue("mapType");
        mapType = (mapType == null ? MapComponent.DEFAULT_MAP_TYPE.getName() : mapType).toUpperCase();
        contextMap.put("latitude", latitude);
        contextMap.put("longitude", longitude);
        contextMap.put("zoom", zoom);
        contextMap.put("mapType", mapType);
        List markerList = (List)element.getParameterValue("markers");
        String markers = markerList == null || markerList.isEmpty() ? "[]" : JacksonUtil.getInstance(context.getJasperReportsContext()).getJsonString(markerList);
        contextMap.put("markerList", markers);
        List pathList = (List)element.getParameterValue("paths");
        String paths = pathList == null || pathList.isEmpty() ? "[]" : JacksonUtil.getInstance(context.getJasperReportsContext()).getJsonString(pathList);
        contextMap.put("pathsList", paths);
        String reqParams = (String)element.getParameterValue("reqParams");
        if (reqParams != null) {
            contextMap.put("reqParams", reqParams);
        }
        return VelocityUtil.processTemplate(MAP_ELEMENT_JSON_TEMPLATE, contextMap);
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

