/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.GenericElementHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultElementHandlerBundle
implements GenericElementHandlerBundle {
    private static final Log log = LogFactory.getLog(DefaultElementHandlerBundle.class);
    public static final String EXCEPTION_MESSAGE_KEY_HANDLERS_NOT_FOUND_FOR_TYPE = "export.common.handlers.not.found.for.type";
    private String namespace;
    private Map<String, Map<String, GenericElementHandler>> elementHandlers;

    @Override
    public GenericElementHandler getHandler(String elementName, String exporterKey) {
        Map<String, GenericElementHandler> handlers = this.elementHandlers.get(elementName);
        if (handlers == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_HANDLERS_NOT_FOUND_FOR_TYPE, this.namespace, elementName);
        }
        GenericElementHandler handler = handlers.get(exporterKey);
        if (handler == null && log.isDebugEnabled()) {
            log.debug("No " + exporterKey + " handler for generic elements of type " + this.namespace + "#" + elementName);
        }
        return handler;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Map<String, Map<String, GenericElementHandler>> getElementHandlers() {
        return this.elementHandlers;
    }

    public void setElementHandlers(Map<String, Map<String, GenericElementHandler>> elementHandlers) {
        this.elementHandlers = elementHandlers;
    }
}

