/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.Serializable;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.fill.BandReportFillerParent;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.DefaultPrintElementOriginator;
import net.sf.jasperreports.engine.fill.DelayedFillActions;
import net.sf.jasperreports.engine.fill.ElementRange;
import net.sf.jasperreports.engine.fill.FillPageKey;
import net.sf.jasperreports.engine.fill.FillerPageAddedEvent;
import net.sf.jasperreports.engine.fill.FillerParent;
import net.sf.jasperreports.engine.fill.GroupFooterElementRange;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillReportTemplate;
import net.sf.jasperreports.engine.fill.JRFillSection;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRPrintBand;
import net.sf.jasperreports.engine.fill.JRResourcesFillUtil;
import net.sf.jasperreports.engine.fill.JRYXComparator;
import net.sf.jasperreports.engine.fill.JasperReportSource;
import net.sf.jasperreports.engine.fill.PrintElementOriginator;
import net.sf.jasperreports.engine.fill.ReportTemplateSource;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.PropertyEvaluationTimeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.SectionTypeEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.StyleResolver;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.apache.commons.javaflow.api.continuable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRBaseFiller
extends BaseReportFiller
implements JRDefaultStyleProvider {
    private static final Log log = LogFactory.getLog(JRBaseFiller.class);
    public static final String EXCEPTION_MESSAGE_KEY_INFINITE_LOOP_CREATING_NEW_PAGE = "fill.common.filler.infinite.loop.creating.new.page";
    public static final String EXCEPTION_MESSAGE_KEY_COLUMN_HEADER_OVERFLOW_INFINITE_LOOP = "fill.common.filler.column.header.overflow.infinite.loop";
    public static final String EXCEPTION_MESSAGE_KEY_CIRCULAR_DEPENDENCY_FOUND = "fill.base.filler.circular.dependency.found";
    public static final String EXCEPTION_MESSAGE_KEY_EXTERNAL_STYLE_NAME_NOT_SET = "fill.base.filler.external.style.name.not.set";
    public static final String EXCEPTION_MESSAGE_KEY_NO_SUCH_GROUP = "fill.base.filler.no.such.group";
    public static final String EXCEPTION_MESSAGE_KEY_PAGE_HEADER_OVERFLOW_INFINITE_LOOP = "fill.common.filler.page.header.overflow.infinite.loop";
    public static final String EXCEPTION_MESSAGE_KEY_UNSUPPORTED_REPORT_SECTION_TYPE = "fill.base.filler.unsupported.report.section.type";
    public static final String EXCEPTION_MESSAGE_KEY_KEEP_TOGETHER_CONTENT_DOES_NOT_FIT = "fill.common.filler.keep.together.content.does.not.fit";
    private static final int PAGE_HEIGHT_PAGINATION_IGNORED = 0x7D000000;
    private static final int PAGE_WIDTH_IGNORED = 0x7D000000;
    private JRStyledTextParser styledTextParser = JRStyledTextParser.getInstance();
    protected String name;
    protected int columnCount;
    protected PrintOrderEnum printOrder;
    protected RunDirectionEnum columnDirection;
    protected int pageWidth;
    protected int maxPageWidth;
    protected int pageHeight;
    protected OrientationEnum orientation;
    private WhenNoDataTypeEnum whenNoDataType;
    protected int columnWidth;
    protected int columnSpacing;
    protected int leftMargin;
    protected int rightMargin;
    protected int topMargin;
    protected int bottomMargin;
    protected boolean isTitleNewPage;
    protected boolean isSummaryNewPage;
    protected boolean isSummaryWithPageHeaderAndFooter;
    protected boolean isFloatColumnFooter;
    protected WhenResourceMissingTypeEnum whenResourceMissingType;
    protected JRFillReportTemplate[] reportTemplates;
    protected List<ReportTemplateSource> templates;
    protected JRStyle defaultStyle;
    protected StyleResolver styleResolver;
    protected JRStyle[] styles;
    protected JRFillGroup[] groups;
    protected JRFillSection missingFillSection;
    protected JRFillBand missingFillBand;
    protected JRFillBand background;
    protected JRFillBand title;
    protected JRFillBand pageHeader;
    protected JRFillBand columnHeader;
    protected JRFillSection detailSection;
    protected JRFillBand columnFooter;
    protected JRFillBand pageFooter;
    protected JRFillBand lastPageFooter;
    protected JRFillBand summary;
    protected JRFillBand noData;
    protected JRPrintPage printPage;
    protected int printPageContentsWidth;
    protected List<JRBand> bands;
    protected Map<Integer, JRBaseFiller> subfillers;
    private boolean bandOverFlowAllowed;
    protected Map<String, Format> dateFormatCache = new HashMap<String, Format>();
    protected Map<String, Format> numberFormatCache = new HashMap<String, Format>();
    protected GroupFooterElementRange groupFooterPositionElementRange;
    protected ElementRange detailElementRange;
    protected ElementRange orphanGroupFooterDetailElementRange;
    protected ElementRange orphanGroupFooterElementRange;
    protected ElementRange floatColumnFooterElementRange;
    protected boolean isCreatingNewPage;
    protected boolean isNewPage;
    protected boolean isNewColumn;
    protected boolean isFirstPageBand;
    protected boolean isFirstColumnBand;
    protected boolean isCrtRecordOnPage;
    protected boolean isCrtRecordOnColumn;
    protected Integer preventOrphanFootersMinLevel;
    protected int crtGroupFootersLevel;
    protected int columnIndex;
    protected int offsetX;
    protected int offsetY;
    protected int columnHeaderOffsetY;
    protected int columnFooterOffsetY;
    protected int lastPageColumnFooterOffsetY;
    protected boolean isLastPageFooter;
    protected boolean isReorderBandElements;
    protected int usedPageHeight = 0;
    private List<DefaultStyleListener> defaultStyleListeners;
    private static final JRStyleSetter DUMMY_STYLE_SETTER = new JRStyleSetter(){

        @Override
        public void setStyle(JRStyle style) {
        }

        @Override
        public void setStyleNameReference(String name) {
        }
    };

    protected JRBaseFiller(JasperReportsContext jasperReportsContext, JasperReportSource reportSource, BandReportFillerParent parent) throws JRException {
        super(jasperReportsContext, reportSource, (FillerParent)parent);
        this.groups = this.mainDataset.groups;
        this.createReportTemplates(this.factory);
        String reportName = this.getBandReportParent() == null ? null : this.getBandReportParent().getReportName();
        this.background = this.createFillBand(this.jasperReport.getBackground(), reportName, BandTypeEnum.BACKGROUND);
        this.title = this.createFillBand(this.jasperReport.getTitle(), reportName, BandTypeEnum.TITLE);
        this.pageHeader = this.createFillBand(this.jasperReport.getPageHeader(), reportName, BandTypeEnum.PAGE_HEADER);
        this.columnHeader = this.createFillBand(this.jasperReport.getColumnHeader(), reportName, BandTypeEnum.COLUMN_HEADER);
        this.detailSection = this.factory.getSection(this.jasperReport.getDetailSection());
        if (this.detailSection != this.missingFillSection) {
            this.detailSection.setOrigin(new JROrigin(reportName, BandTypeEnum.DETAIL));
        }
        this.columnFooter = this.createFillBand(this.jasperReport.getColumnFooter(), reportName, BandTypeEnum.COLUMN_FOOTER);
        this.pageFooter = this.createFillBand(this.jasperReport.getPageFooter(), reportName, BandTypeEnum.PAGE_FOOTER);
        this.lastPageFooter = this.createFillBand(this.jasperReport.getLastPageFooter(), reportName, BandTypeEnum.LAST_PAGE_FOOTER);
        this.summary = this.createFillBand(this.jasperReport.getSummary(), reportName, BandTypeEnum.SUMMARY);
        if (this.summary != this.missingFillBand && this.summary.isEmpty()) {
            this.summary = this.missingFillBand;
        }
        this.noData = this.createFillBand(this.jasperReport.getNoData(), reportName, BandTypeEnum.NO_DATA);
        this.initDatasets();
        this.initBands();
    }

    @Override
    protected void jasperReportSet() {
        SectionTypeEnum sectionType = this.jasperReport.getSectionType();
        if (sectionType != null && sectionType != SectionTypeEnum.BAND) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNSUPPORTED_REPORT_SECTION_TYPE, this.jasperReport.getSectionType());
        }
        this.name = this.jasperReport.getName();
        this.columnCount = this.jasperReport.getColumnCount();
        this.printOrder = this.jasperReport.getPrintOrderValue();
        this.columnDirection = this.jasperReport.getColumnDirection();
        this.pageWidth = this.jasperReport.getPageWidth();
        this.pageHeight = this.jasperReport.getPageHeight();
        this.orientation = this.jasperReport.getOrientationValue();
        this.whenNoDataType = this.jasperReport.getWhenNoDataTypeValue();
        this.columnWidth = this.jasperReport.getColumnWidth();
        this.columnSpacing = this.jasperReport.getColumnSpacing();
        this.leftMargin = this.jasperReport.getLeftMargin();
        this.rightMargin = this.jasperReport.getRightMargin();
        this.topMargin = this.jasperReport.getTopMargin();
        this.bottomMargin = this.jasperReport.getBottomMargin();
        this.isTitleNewPage = this.jasperReport.isTitleNewPage();
        this.isSummaryNewPage = this.jasperReport.isSummaryNewPage();
        this.isSummaryWithPageHeaderAndFooter = this.jasperReport.isSummaryWithPageHeaderAndFooter();
        this.isFloatColumnFooter = this.jasperReport.isFloatColumnFooter();
        this.whenResourceMissingType = this.jasperReport.getWhenResourceMissingTypeValue();
    }

    @Override
    protected JRFillObjectFactory initFillFactory() {
        JRFillObjectFactory fillFactory = new JRFillObjectFactory(this);
        this.defaultStyleListeners = new ArrayList<DefaultStyleListener>();
        this.missingFillBand = new JRFillBand(this, null, fillFactory);
        this.missingFillSection = new JRFillSection(this, null, fillFactory);
        return fillFactory;
    }

    private JRFillBand createFillBand(JRBand reportBand, String reportName, BandTypeEnum bandType) {
        JRFillBand fillBand = this.factory.getBand(reportBand);
        if (fillBand != this.missingFillBand) {
            JROrigin origin = new JROrigin(reportName, bandType);
            fillBand.setOrigin(origin);
        }
        return fillBand;
    }

    @Override
    protected void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        super.setJasperReportsContext(jasperReportsContext);
        this.styleResolver = new StyleResolver(jasperReportsContext);
    }

    protected Map<String, JRFillField> getFieldsMap() {
        return this.mainDataset.fieldsMap;
    }

    protected Map<String, JRFillVariable> getVariablesMap() {
        return this.mainDataset.variablesMap;
    }

    protected JRFillField getField(String fieldName) {
        return this.mainDataset.getFillField(fieldName);
    }

    private void initBands() {
        this.bands = new ArrayList<JRBand>(8 + (this.groups == null ? 0 : 2 * this.groups.length));
        this.bands.add(this.title);
        this.bands.add(this.summary);
        this.bands.add(this.pageHeader);
        this.bands.add(this.pageFooter);
        this.bands.add(this.lastPageFooter);
        this.bands.add(this.columnHeader);
        this.bands.add(this.columnFooter);
        if (this.detailSection.getBands() != null) {
            this.bands.addAll(Arrays.asList(this.detailSection.getBands()));
        }
        this.bands.add(this.noData);
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                if (group.getGroupHeaderSection().getBands() != null) {
                    this.bands.addAll(Arrays.asList(group.getGroupHeaderSection().getBands()));
                }
                if (group.getGroupFooterSection().getBands() == null) continue;
                this.bands.addAll(Arrays.asList(group.getGroupFooterSection().getBands()));
            }
        }
        this.initBandsNowEvaluationTimes();
    }

    private void initBandsNowEvaluationTimes() {
        JREvaluationTime[] groupEvaluationTimes;
        if (this.groups == null) {
            groupEvaluationTimes = new JREvaluationTime[]{};
        } else {
            int i;
            groupEvaluationTimes = new JREvaluationTime[this.groups.length];
            for (i = 0; i < this.groups.length; ++i) {
                groupEvaluationTimes[i] = JREvaluationTime.getGroupEvaluationTime(this.groups[i].getName());
            }
            for (i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                JRFillSection footer = (JRFillSection)group.getGroupFooterSection();
                for (int j = i; j < groupEvaluationTimes.length; ++j) {
                    footer.addNowEvaluationTime(groupEvaluationTimes[j]);
                }
            }
        }
        this.columnFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_COLUMN);
        this.pageFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_COLUMN);
        this.pageFooter.addNowEvaluationTime(JREvaluationTime.EVALUATION_TIME_PAGE);
        this.summary.addNowEvaluationTimes(groupEvaluationTimes);
        this.noData.addNowEvaluationTimes(groupEvaluationTimes);
    }

    protected BandReportFillerParent getBandReportParent() {
        return (BandReportFillerParent)this.parent;
    }

    protected List<String> getPrintTransferPropertyPrefixes() {
        return this.printTransferPropertyPrefixes;
    }

    public JRStyledTextParser getStyledTextParser() {
        return this.styledTextParser;
    }

    protected JRStyledTextUtil getStyledTextUtil() {
        return this.fillContext.getStyledTextUtil();
    }

    public int getCurrentPageCount() {
        return this.getMasterFiller().jasperPrint.getPages().size();
    }

    @Override
    public JRStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    @Override
    public StyleResolver getStyleResolver() {
        return this.styleResolver;
    }

    protected boolean isSubreportRunToBottom() {
        return this.getBandReportParent() != null && this.getBandReportParent().isRunToBottom();
    }

    public JRPrintPage getCurrentPage() {
        return this.printPage;
    }

    protected int getCurrentPageContentsWidth() {
        return this.printPageContentsWidth;
    }

    protected abstract void setPageHeight(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @continuable
    public JasperPrint fill(Map<String, Object> parameterValues) throws JRException {
        if (parameterValues == null) {
            parameterValues = new HashMap<String, Object>();
        }
        if (log.isDebugEnabled()) {
            log.debug("Fill " + this.fillerId + ": filling report");
        }
        this.setParametersToContext(parameterValues);
        this.fillingThread = Thread.currentThread();
        JRResourcesFillUtil.ResourcesFillContext resourcesContext = JRResourcesFillUtil.setResourcesFillContext(parameterValues);
        boolean success = false;
        try {
            this.createBoundElemementMaps();
            if (this.parent != null) {
                this.getBandReportParent().registerSubfiller(this);
            }
            this.setParameters(parameterValues);
            this.setBookmarkHelper();
            this.loadStyles();
            this.jasperPrint.setName(this.name);
            this.jasperPrint.setPageWidth(this.pageWidth);
            this.jasperPrint.setPageHeight(this.pageHeight);
            this.jasperPrint.setTopMargin(this.topMargin);
            this.jasperPrint.setLeftMargin(this.leftMargin);
            this.jasperPrint.setBottomMargin(this.bottomMargin);
            this.jasperPrint.setRightMargin(this.rightMargin);
            this.jasperPrint.setOrientation(this.orientation);
            this.jasperPrint.setFormatFactoryClass(this.jasperReport.getFormatFactoryClass());
            this.jasperPrint.setLocaleCode(JRDataUtils.getLocaleCode(this.getLocale()));
            this.jasperPrint.setTimeZoneId(JRDataUtils.getTimeZoneId(this.getTimeZone()));
            this.propertiesUtil.transferProperties(this.mainDataset, (JRPropertiesHolder)this.jasperPrint, "net.sf.jasperreports.print.transfer.");
            this.jasperPrint.setDefaultStyle(this.defaultStyle);
            if (this.styles != null && this.styles.length > 0) {
                for (int i = 0; i < this.styles.length; ++i) {
                    this.addPrintStyle(this.styles[i]);
                }
            }
            this.mainDataset.start();
            this.fillReport();
            this.mainDataset.evaluateProperties(PropertyEvaluationTimeEnum.REPORT);
            this.propertiesUtil.transferProperties(this.mainDataset, (JRPropertiesHolder)this.jasperPrint, "net.sf.jasperreports.print.transfer.");
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": ended");
            }
            success = true;
            JasperPrint jasperPrint = this.jasperPrint;
            return jasperPrint;
        }
        finally {
            this.mainDataset.closeDatasource();
            this.mainDataset.disposeParameterContributors();
            if (success && this.parent == null) {
                this.fillContext.cacheDone();
            }
            if (this.parent != null) {
                this.getBandReportParent().unregisterSubfiller(this);
            }
            this.delayedActions.dispose();
            this.fillingThread = null;
            this.abortSubfillers();
            if (this.parent == null) {
                this.fillContext.dispose();
            }
            JRResourcesFillUtil.revertResourcesFillContext(resourcesContext);
        }
    }

    public void addPrintStyle(JRStyle style) throws JRException {
        this.jasperPrint.addStyle(style, true);
    }

    protected void addDefaultStyleListener(DefaultStyleListener listener) {
        this.defaultStyleListeners.add(listener);
    }

    protected void setDefaultStyle(JRStyle style) {
        this.defaultStyle = style;
        for (DefaultStyleListener listener : this.defaultStyleListeners) {
            listener.defaultStyleSet(style);
        }
    }

    protected void loadStyles() throws JRException {
        List<JRStyle> styleList = this.collectStyles();
        JRStyle reportDefaultStyle = this.jasperReport.getDefaultStyle();
        if (reportDefaultStyle == null) {
            this.lookupExternalDefaultStyle(styleList);
        }
        List<JRStyle> includedStyles = this.factory.setStyles(styleList);
        if (this.getBandReportParent() != null) {
            this.getBandReportParent().registerReportStyles(includedStyles);
        }
        this.styles = includedStyles.toArray(new JRStyle[includedStyles.size()]);
        if (reportDefaultStyle != null) {
            this.setDefaultStyle(this.factory.getStyle(reportDefaultStyle));
        }
    }

    public void registerReportStyles(UUID id, List<JRStyle> styles) {
        if (this.getBandReportParent() == null) {
            this.fillContext.registerReportStyles(this.jasperReport, id, styles);
        } else {
            String reportLocation = this.getBandReportParent().getReportLocation();
            if (reportLocation != null) {
                this.fillContext.registerReportStyles(reportLocation, id, styles);
            }
        }
    }

    protected List<JRStyle> collectStyles() throws JRException {
        List<JRStyle> styleList = this.collectTemplateStyles();
        JRStyle[] reportStyles = this.jasperReport.getStyles();
        if (reportStyles != null) {
            this.styles = new JRStyle[reportStyles.length];
            for (int i = 0; i < reportStyles.length; ++i) {
                JRStyle style = reportStyles[i];
                styleList.add(style);
                this.factory.registerDelayedStyleSetter(DUMMY_STYLE_SETTER, style.getName());
            }
        }
        return styleList;
    }

    protected void collectTemplates() throws JRException {
        Collection paramTemplates;
        this.templates = new ArrayList<ReportTemplateSource>();
        if (this.reportTemplates != null) {
            for (JRFillReportTemplate reportTemplate : this.reportTemplates) {
                ReportTemplateSource template = reportTemplate.evaluate();
                if (template == null) continue;
                this.templates.add(template);
            }
        }
        if ((paramTemplates = (Collection)this.mainDataset.getParameterValue("REPORT_TEMPLATES", true)) != null) {
            for (JRTemplate template : paramTemplates) {
                this.templates.add(ReportTemplateSource.of(template));
            }
        }
    }

    public List<JRTemplate> getTemplates() {
        return this.templates.stream().map(source -> source.getTemplate()).collect(Collectors.toList());
    }

    protected List<JRStyle> collectTemplateStyles() throws JRException {
        this.collectTemplates();
        ArrayList<JRStyle> externalStyles = new ArrayList<JRStyle>();
        HashSet<String> loadedLocations = new HashSet<String>();
        for (ReportTemplateSource template : this.templates) {
            this.collectStyles(template, externalStyles, loadedLocations);
        }
        return externalStyles;
    }

    protected void collectStyles(ReportTemplateSource template, List<JRStyle> externalStyles, Set<String> loadedLocations) throws JRException {
        HashSet<String> parentLocations = new HashSet<String>();
        this.collectStyles(template, externalStyles, loadedLocations, parentLocations);
    }

    protected void collectStyles(ReportTemplateSource templateSource, List<JRStyle> externalStyles, Set<String> loadedLocations, Set<String> templateParentLocations) throws JRException {
        String templateLocation;
        String string = templateLocation = templateSource.getTemplateResourceInfo() == null ? null : templateSource.getTemplateResourceInfo().getRepositoryResourceLocation();
        if (templateLocation != null && !templateParentLocations.add(templateLocation)) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CIRCULAR_DEPENDENCY_FOUND, templateLocation);
        }
        if (templateLocation != null && !loadedLocations.add(templateLocation)) {
            return;
        }
        this.collectIncludedTemplates(templateSource, externalStyles, loadedLocations, templateParentLocations);
        JRStyle[] templateStyles = templateSource.getTemplate().getStyles();
        if (templateStyles != null) {
            for (int i = 0; i < templateStyles.length; ++i) {
                JRStyle style = templateStyles[i];
                String styleName = style.getName();
                if (styleName == null) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_EXTERNAL_STYLE_NAME_NOT_SET, (Object[])null);
                }
                externalStyles.add(style);
            }
        }
    }

    protected void collectIncludedTemplates(ReportTemplateSource templateSource, List<JRStyle> externalStyles, Set<String> loadedLocations, Set<String> templateParentLocations) throws JRException {
        JRTemplateReference[] includedTemplates = templateSource.getTemplate().getIncludedTemplates();
        if (includedTemplates != null && includedTemplates.length > 0) {
            RepositoryResourceContext currentContext = this.repositoryContext.getResourceContext();
            String contextLocation = templateSource.getTemplateResourceInfo() == null ? null : templateSource.getTemplateResourceInfo().getRepositoryContextLocation();
            SimpleRepositoryResourceContext templateResourceContext = SimpleRepositoryResourceContext.of(contextLocation, currentContext == null ? null : currentContext.getDerivedContextFallback());
            SimpleRepositoryContext templateRepositoryContext = SimpleRepositoryContext.of(this.repositoryContext.getJasperReportsContext(), templateResourceContext);
            for (int i = 0; i < includedTemplates.length; ++i) {
                JRTemplateReference reference = includedTemplates[i];
                String location = reference.getLocation();
                ReportTemplateSource includedTemplate = JRFillReportTemplate.loadTemplate(location, this, templateRepositoryContext);
                this.collectStyles(includedTemplate, externalStyles, loadedLocations, templateParentLocations);
            }
        }
    }

    protected void lookupExternalDefaultStyle(Collection<JRStyle> styleList) {
        JRStyle defStyle = null;
        for (JRStyle style : styleList) {
            if (!style.isDefault()) continue;
            defStyle = style;
        }
        if (defStyle != null) {
            this.factory.registerDelayedStyleSetter(new JRStyleSetter(){

                @Override
                public void setStyle(JRStyle style) {
                    if (style.isDefault()) {
                        JRBaseFiller.this.setDefaultStyle(style);
                    }
                }

                @Override
                public void setStyleNameReference(String name) {
                }
            }, defStyle.getName());
        }
    }

    private void createBoundElemementMaps() {
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_MASTER);
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_REPORT);
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_PAGE);
        this.createBoundElementMaps(JREvaluationTime.EVALUATION_TIME_COLUMN);
        if (this.groups != null) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.createBoundElementMaps(JREvaluationTime.getGroupEvaluationTime(this.groups[i].getName()));
            }
        }
        for (JRFillBand jRFillBand : this.bands) {
            this.createBoundElementMaps(JREvaluationTime.getBandEvaluationTime(jRFillBand));
        }
    }

    private void abortSubfillers() {
        if (this.subfillers != null && !this.subfillers.isEmpty()) {
            for (JRBaseFiller subfiller : this.subfillers.values()) {
                if (subfiller.getBandReportParent() == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Fill " + this.fillerId + ": Aborting subfiller " + subfiller.fillerId);
                }
                subfiller.getBandReportParent().abortSubfiller(subfiller);
            }
        }
    }

    @continuable
    protected abstract void fillReport() throws JRException;

    @Override
    protected void ignorePaginationSet(Map<String, Object> parameterValues) {
        if (this.ignorePagination) {
            this.isTitleNewPage = false;
            this.isSummaryNewPage = false;
            if (this.groups != null) {
                for (int i = 0; i < this.groups.length; ++i) {
                    this.groups[i].setStartNewPage(false);
                    this.groups[i].setResetPageNumber(false);
                    this.groups[i].setStartNewColumn(false);
                }
            }
            if (this.isMasterReport() || !this.getBandReportParent().isParentPagination()) {
                int maxPageHeight = this.getMaxPageHeight(parameterValues);
                this.setPageHeight(maxPageHeight);
            }
        }
        this.maxPageWidth = this.getMaxPageWidth(parameterValues);
    }

    protected int getMaxPageHeight(Map<String, Object> parameterValues) {
        int maxPageHeight;
        Integer maxPageHeightParam = (Integer)parameterValues.get("net.sf.jasperreports.max.page.height");
        int n = maxPageHeight = maxPageHeightParam != null ? maxPageHeightParam : 0x7D000000;
        if (maxPageHeight < this.pageHeight) {
            if (log.isDebugEnabled()) {
                log.debug("max page height " + maxPageHeight + " smaller than report page height " + this.pageHeight);
            }
            maxPageHeight = this.pageHeight;
        }
        if (log.isDebugEnabled()) {
            log.debug("max page height is " + maxPageHeight);
        }
        return maxPageHeight;
    }

    protected int getMaxPageWidth(Map<String, Object> parameterValues) {
        int maxPageWidth;
        Integer maxPageWidthParam = (Integer)parameterValues.get("net.sf.jasperreports.max.page.width");
        int n = maxPageWidth = maxPageWidthParam != null ? maxPageWidthParam : 0x7D000000;
        if (maxPageWidth < this.pageWidth) {
            if (log.isDebugEnabled()) {
                log.debug("max page width " + maxPageWidth + " smaller than report page width " + this.pageWidth);
            }
            maxPageWidth = this.pageWidth;
        }
        if (log.isDebugEnabled()) {
            log.debug("max page width is " + maxPageWidth);
        }
        return maxPageWidth;
    }

    protected void recordUsedPageHeight(int pageHeight) {
        if (pageHeight > this.usedPageHeight) {
            this.usedPageHeight = pageHeight;
        }
    }

    protected ResourceBundle getResourceBundle() {
        return this.mainDataset.resourceBundle;
    }

    protected WhenNoDataTypeEnum getWhenNoDataType() {
        WhenNoDataTypeEnum result = this.whenNoDataType;
        if (result == null) {
            result = WhenNoDataTypeEnum.getByName(this.propertiesUtil.getProperty(this.mainDataset, "net.sf.jasperreports.when.no.data.type"));
        }
        return result;
    }

    public Format getDateFormat(String pattern) {
        return this.getDateFormat(pattern, null);
    }

    protected Format getDateFormat(String pattern, TimeZone timeZone) {
        Locale lc = this.getLocale();
        TimeZone tz = timeZone == null ? this.getTimeZone() : timeZone;
        String key = pattern + "|" + JRDataUtils.getLocaleCode(lc) + "|" + JRDataUtils.getTimeZoneId(tz);
        Format format = this.dateFormatCache.get(key);
        if (format == null && (format = this.getFormatFactory().createDateFormat(pattern, lc, tz)) != null) {
            this.dateFormatCache.put(key, format);
        }
        return format;
    }

    public Format getNumberFormat(String pattern) {
        Locale lc = this.getLocale();
        String key = pattern + "|" + JRDataUtils.getLocaleCode(lc);
        Format format = this.numberFormatCache.get(key);
        if (format == null && (format = this.getFormatFactory().createNumberFormat(pattern, lc)) != null) {
            this.numberFormatCache.put(key, format);
        }
        return format;
    }

    protected boolean hasMasterFormatFactory() {
        return !this.isSubreport() || this.getFormatFactory().getClass().getName().equals(this.fillContext.getMasterFormatFactory().getClass().getName());
    }

    protected boolean hasMasterLocale() {
        return !this.isSubreport() || this.getLocale().equals(this.fillContext.getMasterLocale());
    }

    protected boolean hasMasterTimeZone() {
        return !this.isSubreport() || this.getTimeZone().equals(this.fillContext.getMasterTimeZone());
    }

    protected void setParameter(String parameterName, Object value) throws JRException {
        this.mainDataset.setParameter(parameterName, value);
    }

    protected void setParameter(JRFillParameter parameter, Object value) throws JRException {
        this.mainDataset.setParameter(parameter, value);
    }

    protected boolean next() throws JRException {
        this.isCrtRecordOnPage = false;
        this.isCrtRecordOnColumn = false;
        return this.mainDataset.next();
    }

    protected void resolveReportBoundElements() throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_REPORT, (byte)3);
    }

    protected void resolvePageBoundElements(byte evaluation) throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_PAGE, evaluation);
    }

    protected void resolveColumnBoundElements(byte evaluation) throws JRException {
        this.resolveBoundElements(JREvaluationTime.EVALUATION_TIME_COLUMN, evaluation);
    }

    protected void resolveGroupBoundElements(byte evaluation, boolean isFinal) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                if ((!group.hasChanged() || !group.isFooterPrinted()) && !isFinal) continue;
                String groupName = group.getName();
                this.resolveBoundElements(JREvaluationTime.getGroupEvaluationTime(groupName), evaluation);
            }
        }
    }

    protected JRPrintPage newPage() {
        Serializable page;
        if (this.fillContext.isUsingVirtualizer()) {
            JRVirtualPrintPage virtualPage = new JRVirtualPrintPage(this.virtualizationContext);
            page = virtualPage;
        } else {
            page = new JRBasePrintPage();
        }
        return page;
    }

    protected void resolveBandBoundElements(JRFillBand band, byte evaluation) throws JRException {
        this.resolveBoundElements(JREvaluationTime.getBandEvaluationTime(band), evaluation);
    }

    protected void registerSubfiller(JRBaseFiller subfiller) {
        if (this.subfillers == null) {
            this.subfillers = new ConcurrentHashMap<Integer, JRBaseFiller>(16, 0.75f, 1);
        }
        this.subfillers.put(subfiller.fillerId, subfiller);
    }

    protected void unregisterSubfiller(JRBaseFiller subfiller) {
        if (this.subfillers != null) {
            this.subfillers.remove(subfiller.fillerId);
        }
    }

    protected void fillBand(JRPrintBand band) {
        int contentsWidth;
        if (this.isReorderBandElements()) {
            ArrayList<JRPrintElement> elements = new ArrayList<JRPrintElement>();
            Iterator<JRPrintElement> it = band.iterateElements();
            while (it.hasNext()) {
                JRPrintElement element = it.next();
                element.setX(element.getX() + this.offsetX);
                element.setY(element.getY() + this.offsetY);
                elements.add(element);
            }
            Collections.sort(elements, new JRYXComparator());
            for (JRPrintElement element : elements) {
                this.printPage.addElement(element);
                this.recordUsedWidth(element);
            }
        } else {
            Iterator<JRPrintElement> it = band.iterateElements();
            while (it.hasNext()) {
                JRPrintElement element = it.next();
                element.setX(element.getX() + this.offsetX);
                element.setY(element.getY() + this.offsetY);
                this.printPage.addElement(element);
                this.recordUsedWidth(element);
            }
        }
        if (this.offsetX + (contentsWidth = band.getContentsWidth()) + this.rightMargin > this.printPageContentsWidth) {
            this.printPageContentsWidth = this.offsetX + contentsWidth + this.rightMargin;
        }
    }

    protected void recordUsedWidth(JRPrintElement element) {
        this.recordUsedPageWidth(element.getX() + element.getWidth() + this.rightMargin);
    }

    protected void addPage(JRPrintPage page) {
        if (!this.isSubreport()) {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": adding page " + (this.jasperPrint.getPages().size() + 1));
            }
            this.addLastPageBookmarks();
            int pageCount = this.jasperPrint.getPages().size();
            if (pageCount > 0 && this.fillListener != null) {
                this.fillListener.pageGenerated(this.jasperPrint, pageCount - 1);
            }
            this.jasperPrint.addPage(page);
            this.fillContext.setPrintPage(page);
        }
    }

    @continuable
    protected void addPageToParent(final boolean ended) throws JRException {
        if (this.printPage == null) {
            return;
        }
        FillerPageAddedEvent pageAdded = new FillerPageAddedEvent(){

            @Override
            public JasperPrint getJasperPrint() {
                return JRBaseFiller.this.jasperPrint;
            }

            @Override
            public JRPrintPage getPage() {
                return JRBaseFiller.this.printPage;
            }

            @Override
            public boolean hasReportEnded() {
                return ended;
            }

            @Override
            public int getPageStretchHeight() {
                return JRBaseFiller.this.offsetY + JRBaseFiller.this.bottomMargin;
            }

            @Override
            public int getPageIndex() {
                Number pageNumber = (Number)JRBaseFiller.this.calculator.getPageNumber().getValue();
                if (pageNumber == null) {
                    return 0;
                }
                return pageNumber.intValue() - 1;
            }

            @Override
            public JRBaseFiller getFiller() {
                return JRBaseFiller.this;
            }

            @Override
            public DelayedFillActions getDelayedActions() {
                return JRBaseFiller.this.delayedActions;
            }
        };
        this.getBandReportParent().addPage(pageAdded);
    }

    protected void setMasterPageVariables(int currentPageIndex, int totalPages) {
        JRFillVariable masterTotalPages;
        JRFillVariable masterCurrentPage = this.getVariable("MASTER_CURRENT_PAGE");
        if (masterCurrentPage != null) {
            masterCurrentPage.setValue(currentPageIndex + 1);
        }
        if ((masterTotalPages = this.getVariable("MASTER_TOTAL_PAGES")) != null) {
            masterTotalPages.setValue(totalPages);
        }
    }

    protected WhenResourceMissingTypeEnum getWhenResourceMissingType() {
        return this.mainDataset.whenResourceMissingType;
    }

    protected boolean isBandOverFlowAllowed() {
        return this.bandOverFlowAllowed;
    }

    protected void setBandOverFlowAllowed(boolean splittableBand) {
        this.bandOverFlowAllowed = splittableBand;
    }

    protected boolean isReorderBandElements() {
        return this.isReorderBandElements;
    }

    protected void setReorderBandElements(boolean isReorderBandElements) {
        this.isReorderBandElements = isReorderBandElements;
    }

    protected int getMasterColumnCount() {
        FillerParent fillerParent = this.parent;
        int colCount = 1;
        while (fillerParent != null) {
            BaseReportFiller filler = fillerParent.getFiller();
            if (filler instanceof JRBaseFiller) {
                colCount *= ((JRBaseFiller)filler).columnCount;
            }
            fillerParent = filler.parent;
        }
        return colCount;
    }

    public BaseReportFiller getMasterFiller() {
        BaseReportFiller filler = this;
        while (filler.parent != null) {
            filler = filler.parent.getFiller();
        }
        return filler;
    }

    protected void addBoundElement(JRFillElement element, JRPrintElement printElement, EvaluationTimeEnum evaluationType, String groupName, JRFillBand band) {
        JRFillGroup group = groupName == null ? null : this.getGroup(groupName);
        this.addBoundElement(element, printElement, evaluationType, group, band);
    }

    protected void addBoundElement(JRFillElement element, JRPrintElement printElement, EvaluationTimeEnum evaluationType, JRGroup group, JRFillBand band) {
        JREvaluationTime evaluationTime = JREvaluationTime.getEvaluationTime(evaluationType, group, band);
        this.addBoundElement(element, printElement, evaluationTime);
    }

    protected void addBoundElement(JRFillElement element, JRPrintElement printElement, JREvaluationTime evaluationTime) {
        int pageIndex = this.currentPageIndex();
        FillPageKey pageKey = new FillPageKey(this.printPage, pageIndex);
        this.addBoundElement(element, printElement, evaluationTime, pageKey);
    }

    protected int currentPageIndex() {
        int pageIndex = ((Number)this.calculator.getPageNumber().getValue()).intValue() - 1;
        return pageIndex;
    }

    protected void subreportPageFilled(JRPrintPage subreportPage) {
        FillPageKey subreportKey = new FillPageKey(subreportPage);
        JRBaseFiller parentFiller = (JRBaseFiller)this.parent.getFiller();
        int parentPageIndex = parentFiller.getJasperPrint().getPages().size() - 1;
        FillPageKey parentKey = new FillPageKey(parentFiller.printPage, parentPageIndex);
        this.moveBoundActions(subreportKey, parentKey);
        this.parent.getFiller().delayedActions.moveMasterEvaluations(this.delayedActions, parentKey);
    }

    protected void moveBoundActions(FillPageKey subreportKey, FillPageKey parentKey) {
        this.delayedActions.moveActions(subreportKey, parentKey);
        if (this.subfillers != null) {
            for (JRBaseFiller subfiller : this.subfillers.values()) {
                subfiller.moveBoundActions(subreportKey, parentKey);
            }
        }
    }

    @Override
    public boolean isPageFinal(int pageIdx) {
        JRPrintPage page = this.jasperPrint.getPages().get(pageIdx);
        return !this.hasBoundActions(page);
    }

    public boolean isPageFinal(JRPrintPage page) {
        return !this.hasBoundActions(page);
    }

    protected boolean hasBoundActions(JRPrintPage page) {
        boolean hasActions = this.delayedActions.hasDelayedActions(page);
        if (hasActions) {
            return true;
        }
        if (this.subfillers != null) {
            for (JRBaseFiller subfiller : this.subfillers.values()) {
                if (!subfiller.hasBoundActions(page)) continue;
                return true;
            }
        }
        return false;
    }

    protected JRFillGroup getGroup(String groupName) {
        JRFillGroup group = null;
        if (this.groups != null) {
            for (int i = 0; i < this.groups.length; ++i) {
                if (!this.groups[i].getName().equals(groupName)) continue;
                group = this.groups[i];
                break;
            }
        }
        if (group == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_SUCH_GROUP, groupName);
        }
        return group;
    }

    protected JRFillGroup getKeepTogetherGroup() {
        Integer keepTogetherGroupLevel = null;
        if (this.groups != null) {
            for (int i = 0; i < this.groups.length; ++i) {
                JRFillGroup group = this.groups[i];
                if (group.getKeepTogetherElementRange() == null || !group.isKeepTogether() && group.hasMinDetails()) continue;
                keepTogetherGroupLevel = i;
                break;
            }
        }
        if (keepTogetherGroupLevel != null || this.orphanGroupFooterDetailElementRange != null) {
            int detailsToMove = Math.max(keepTogetherGroupLevel == null ? 0 : this.groups[keepTogetherGroupLevel].getDetailsCount(), this.orphanGroupFooterDetailElementRange == null ? 0 : 1);
            int lcMaxGrpIdx = keepTogetherGroupLevel == null ? this.groups.length : keepTogetherGroupLevel;
            for (int i = 0; i < lcMaxGrpIdx; ++i) {
                JRFillGroup group = this.groups[i];
                if (group.getKeepTogetherElementRange() == null || group.hasMinDetails(detailsToMove)) continue;
                keepTogetherGroupLevel = i;
                break;
            }
        }
        return keepTogetherGroupLevel == null ? null : this.groups[keepTogetherGroupLevel];
    }

    protected void createReportTemplates(JRFillObjectFactory factory) {
        JRReportTemplate[] templates = this.jasperReport.getTemplates();
        if (templates != null) {
            this.reportTemplates = new JRFillReportTemplate[templates.length];
            for (int i = 0; i < templates.length; ++i) {
                JRReportTemplate template = templates[i];
                this.reportTemplates[i] = factory.getReportTemplate(template);
            }
        }
    }

    protected int getFillerId() {
        return this.fillerId;
    }

    protected PrintElementOriginator assignElementId(JRFillElement fillElement) {
        int id = this.getFillContext().generateFillElementId();
        DefaultPrintElementOriginator originator = new DefaultPrintElementOriginator(id);
        return originator;
    }

    protected static interface DefaultStyleListener {
        public void defaultStyleSet(JRStyle var1);
    }
}

