/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.lang.constant.Constable;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.AwtFontAttribute;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontSet;
import net.sf.jasperreports.engine.fonts.FontSetFamily;
import net.sf.jasperreports.engine.fonts.FontSetFamilyInfo;
import net.sf.jasperreports.engine.fonts.FontSetInfo;
import net.sf.jasperreports.engine.util.JRFontNotFoundException;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FontUtil {
    private static final Log log = LogFactory.getLog(FontUtil.class);
    public static final String EXCEPTION_MESSAGE_KEY_NULL_FONT = "engine.fonts.null.font";
    public static final String EXCEPTION_MESSAGE_KEY_FONT_SET_FAMILY_NOT_FOUND = "util.font.set.family.not.found";
    private JasperReportsContext jasperReportsContext;
    private static final InheritableThreadLocal<Set<String>> threadMissingFontsCache = new InheritableThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };

    private FontUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static FontUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new FontUtil(jasperReportsContext);
    }

    public static void copyNonNullOwnProperties(JRFont srcFont, JRFont destFont) {
        if (srcFont != null && destFont != null) {
            if (srcFont.getOwnFontName() != null) {
                destFont.setFontName(srcFont.getOwnFontName());
            }
            if (srcFont.isOwnBold() != null) {
                destFont.setBold(srcFont.isOwnBold());
            }
            if (srcFont.isOwnItalic() != null) {
                destFont.setItalic(srcFont.isOwnItalic());
            }
            if (srcFont.isOwnUnderline() != null) {
                destFont.setUnderline(srcFont.isOwnUnderline());
            }
            if (srcFont.isOwnStrikeThrough() != null) {
                destFont.setStrikeThrough(srcFont.isOwnStrikeThrough());
            }
            if (srcFont.getOwnFontsize() != null) {
                destFont.setFontSize(srcFont.getOwnFontsize());
            }
            if (srcFont.getOwnPdfFontName() != null) {
                destFont.setPdfFontName(srcFont.getOwnPdfFontName());
            }
            if (srcFont.getOwnPdfEncoding() != null) {
                destFont.setPdfEncoding(srcFont.getOwnPdfEncoding());
            }
            if (srcFont.isOwnPdfEmbedded() != null) {
                destFont.setPdfEmbedded(srcFont.isOwnPdfEmbedded());
            }
        }
    }

    public Map<AttributedCharacterIterator.Attribute, Object> getAttributesWithoutAwtFont(Map<AttributedCharacterIterator.Attribute, Object> attributes, JRFont font) {
        attributes.put(TextAttribute.FAMILY, font.getFontName());
        attributes.put(TextAttribute.SIZE, Float.valueOf(font.getFontsize()));
        if (font.isBold()) {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (font.isItalic()) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (font.isUnderline()) {
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (font.isStrikeThrough()) {
            attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        attributes.put(JRTextAttribute.PDF_FONT_NAME, font.getPdfFontName());
        attributes.put(JRTextAttribute.PDF_ENCODING, font.getPdfEncoding());
        if (font.isPdfEmbedded()) {
            attributes.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.TRUE);
        }
        return attributes;
    }

    public FontInfo getFontInfo(String name, boolean ignoreCase, Locale locale) {
        FontInfo awtFamilyMatchFontInfo = null;
        List<FontFamily> families = this.jasperReportsContext.getExtensions(FontFamily.class);
        for (FontFamily family : families) {
            if (locale != null && !family.supportsLocale(locale)) continue;
            if (FontUtil.equals(name, family.getName(), ignoreCase)) {
                return new FontInfo(family, null, 0);
            }
            FontFace face = family.getNormalFace();
            if (face != null) {
                if (FontUtil.equals(name, face.getName(), ignoreCase)) {
                    return new FontInfo(family, face, 0);
                }
                if (awtFamilyMatchFontInfo == null && face.getFont() != null && FontUtil.equals(name, face.getFont().getFamily(), ignoreCase)) {
                    awtFamilyMatchFontInfo = new FontInfo(family, face, 0);
                }
            }
            if ((face = family.getBoldFace()) != null) {
                if (FontUtil.equals(name, face.getName(), ignoreCase)) {
                    return new FontInfo(family, face, 1);
                }
                if (awtFamilyMatchFontInfo == null && face.getFont() != null && FontUtil.equals(name, face.getFont().getFamily(), ignoreCase)) {
                    awtFamilyMatchFontInfo = new FontInfo(family, face, 1);
                }
            }
            if ((face = family.getItalicFace()) != null) {
                if (FontUtil.equals(name, face.getName(), ignoreCase)) {
                    return new FontInfo(family, face, 2);
                }
                if (awtFamilyMatchFontInfo == null && face.getFont() != null && FontUtil.equals(name, face.getFont().getFamily(), ignoreCase)) {
                    awtFamilyMatchFontInfo = new FontInfo(family, face, 2);
                }
            }
            if ((face = family.getBoldItalicFace()) == null) continue;
            if (FontUtil.equals(name, face.getName(), ignoreCase)) {
                return new FontInfo(family, face, 3);
            }
            if (awtFamilyMatchFontInfo != null || face.getFont() == null || !FontUtil.equals(name, face.getFont().getFamily(), ignoreCase)) continue;
            awtFamilyMatchFontInfo = new FontInfo(family, face, 3);
        }
        return awtFamilyMatchFontInfo;
    }

    private static boolean equals(String value1, String value2, boolean ignoreCase) {
        return ignoreCase ? value1.equalsIgnoreCase(value2) : value1.equals(value2);
    }

    public FontInfo getFontInfo(String name, Locale locale) {
        return this.getFontInfo(name, false, locale);
    }

    public FontSetInfo getFontSetInfo(String name, Locale locale, boolean ignoreMissingFonts) {
        List<FontFamily> allFontFamilies = this.jasperReportsContext.getExtensions(FontFamily.class);
        HashMap<String, FontFamily> fontFamilies = new HashMap<String, FontFamily>(allFontFamilies.size() * 4 / 3, 0.75f);
        for (FontFamily family : allFontFamilies) {
            if (family.getName() == null || locale != null && !family.supportsLocale(locale)) continue;
            fontFamilies.put(family.getName(), family);
        }
        LinkedHashMap<String, FontSetFamilyInfo> setFamilyInfos = new LinkedHashMap<String, FontSetFamilyInfo>();
        List<FontSet> allSets = this.jasperReportsContext.getExtensions(FontSet.class);
        FontSet foundFontSet = null;
        FontSetFamilyInfo primaryFamily = null;
        for (FontSet fontSet : allSets) {
            if (!name.equals(fontSet.getName())) continue;
            foundFontSet = fontSet;
            List<FontSetFamily> setFamilies = fontSet.getFamilies();
            for (FontSetFamily fontSetFamily : setFamilies) {
                FontFamily fontFamily = (FontFamily)fontFamilies.get(fontSetFamily.getFamilyName());
                if (fontFamily != null) {
                    FontSetFamilyInfo familyInfo = new FontSetFamilyInfo(fontSetFamily, fontFamily);
                    setFamilyInfos.put(fontSetFamily.getFamilyName(), familyInfo);
                    if (!fontSetFamily.isPrimary()) continue;
                    primaryFamily = familyInfo;
                    continue;
                }
                if (ignoreMissingFonts) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Font family " + fontSetFamily.getFamilyName() + " was not found for font set " + name);
                    continue;
                }
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FONT_SET_FAMILY_NOT_FOUND, fontSetFamily.getFamilyName(), name);
            }
        }
        if (foundFontSet == null) {
            return null;
        }
        ArrayList<FontSetFamilyInfo> familyInfoList = new ArrayList<FontSetFamilyInfo>(setFamilyInfos.values());
        if (primaryFamily == null && !familyInfoList.isEmpty()) {
            primaryFamily = (FontSetFamilyInfo)familyInfoList.get(0);
        }
        return new FontSetInfo(foundFontSet, primaryFamily, familyInfoList);
    }

    public String getExportFontFamily(String name, Locale locale, String exporterKey) {
        FontInfo fontInfo = this.getFontInfo(name, locale);
        if (fontInfo != null) {
            FontFamily family = fontInfo.getFontFamily();
            String exportFont = family.getExportFont(exporterKey);
            return exportFont == null ? name : exportFont;
        }
        FontSetInfo fontSetInfo = this.getFontSetInfo(name, locale, true);
        if (fontSetInfo != null) {
            String exportFont = fontSetInfo.getFontSet().getExportFont(exporterKey);
            return exportFont == null ? name : exportFont;
        }
        return name;
    }

    public Collection<String> getFontFamilyNames() {
        TreeSet<String> familyNames = new TreeSet<String>();
        this.collectFontFamilyNames(familyNames);
        return familyNames;
    }

    protected void collectFontFamilyNames(Collection<String> names) {
        List<FontFamily> families = this.jasperReportsContext.getExtensions(FontFamily.class);
        for (FontFamily family : families) {
            if (!family.isVisible()) continue;
            names.add(family.getName());
        }
    }

    public Collection<String> getFontNames() {
        TreeSet<String> fontNames = new TreeSet<String>();
        this.collectFontFamilyNames(fontNames);
        this.collectFontSetNames(fontNames);
        return fontNames;
    }

    protected void collectFontSetNames(Collection<String> names) {
        List<FontSet> fontSets = this.jasperReportsContext.getExtensions(FontSet.class);
        for (FontSet fontSet : fontSets) {
            names.add(fontSet.getName());
        }
    }

    public Font getAwtFontFromBundles(String name, int style, float size, Locale locale, boolean ignoreMissingFont) {
        return this.getAwtFontFromBundles(false, name, style, size, locale, ignoreMissingFont);
    }

    public Font getAwtFontFromBundles(boolean ignoreCase, String name, int style, float size, Locale locale, boolean ignoreMissingFont) {
        FontInfo fontInfo;
        Font awtFont = null;
        FontInfo fontInfo2 = fontInfo = ignoreCase ? this.getFontInfo(name, true, locale) : this.getFontInfo(name, locale);
        if (fontInfo != null) {
            awtFont = this.getAwtFont(fontInfo, style, size, ignoreMissingFont);
        }
        return awtFont;
    }

    protected Font getAwtFont(FontInfo fontInfo, int style, float size, boolean ignoreMissingFont) {
        Font awtFont;
        int faceStyle = 0;
        FontFamily family = fontInfo.getFontFamily();
        FontFace face = fontInfo.getFontFace();
        if (face == null) {
            if ((style & 1) > 0 && (style & 2) > 0) {
                face = family.getBoldItalicFace();
                faceStyle = 3;
            }
            if ((face == null || face.getFont() == null) && (style & 1) > 0) {
                face = family.getBoldFace();
                faceStyle = 1;
            }
            if ((face == null || face.getFont() == null) && (style & 2) > 0) {
                face = family.getItalicFace();
                faceStyle = 2;
            }
            if (face == null || face.getFont() == null) {
                face = family.getNormalFace();
                faceStyle = 0;
            }
        } else {
            faceStyle = fontInfo.getStyle();
        }
        if (face == null || face.getFont() == null) {
            this.checkAwtFont(family.getName(), ignoreMissingFont);
            awtFont = new Font(family.getName(), style, (int)size);
            awtFont = awtFont.deriveFont(size);
        } else {
            awtFont = face.getFont();
            if (awtFont == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NULL_FONT, face.getName(), family.getName());
            }
            awtFont = awtFont.deriveFont(style, size);
        }
        return awtFont;
    }

    public Font getAwtFontFromBundles(AwtFontAttribute fontAttribute, int style, float size, Locale locale, boolean ignoreMissingFont) {
        FontInfo fontInfo = fontAttribute.getFontInfo();
        if (fontInfo == null) {
            fontInfo = this.getFontInfo(fontAttribute.getFamily(), locale);
        }
        Font awtFont = null;
        if (fontInfo != null) {
            awtFont = this.getAwtFont(fontInfo, style, size, ignoreMissingFont);
        }
        return awtFont;
    }

    public void resetThreadMissingFontsCache() {
        threadMissingFontsCache.set(new HashSet());
    }

    public void checkAwtFont(String name, boolean ignoreMissingFont) {
        if (!JRGraphEnvInitializer.isAwtFontAvailable(name)) {
            if (ignoreMissingFont) {
                Set missingFontNames = (Set)threadMissingFontsCache.get();
                if (!missingFontNames.contains(name)) {
                    missingFontNames.add(name);
                    if (log.isWarnEnabled()) {
                        log.warn("Font '" + name + "' is not available to the JVM. For more details, see http://jasperreports.sourceforge.net/api/net/sf/jasperreports/engine/util/JRFontNotFoundException.html");
                    }
                }
            } else {
                throw new JRFontNotFoundException(name);
            }
        }
    }

    public Font getAwtFont(JRFont font, Locale locale) {
        if (font == null) {
            return null;
        }
        Font awtFont = this.getAwtFontFromBundles(font.getFontName(), (font.isBold() ? 1 : 0) | (font.isItalic() ? 2 : 0), font.getFontsize(), locale, true);
        if (awtFont == null) {
            awtFont = new Font(this.getAttributesWithoutAwtFont(new HashMap<AttributedCharacterIterator.Attribute, Object>(), font));
        } else {
            HashMap<TextAttribute, Constable> attributes = new HashMap<TextAttribute, Constable>();
            if (font.isUnderline()) {
                attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (font.isStrikeThrough()) {
                attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            if (!attributes.isEmpty()) {
                awtFont = awtFont.deriveFont(attributes);
            }
        }
        return awtFont;
    }

    public Font resolveDeserializedFont(Font font) {
        String fontName = font.getName();
        Font newFont = this.getAwtFontFromBundles(fontName, font.getStyle(), font.getSize2D(), null, true);
        if (newFont != null) {
            return newFont.deriveFont(font.getAttributes());
        }
        return font;
    }

    private FontUtil() {
    }
}

