/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.xmla;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapHierarchyLevel;
import net.sf.jasperreports.olap.xmla.JRXmlaHierarchyLevel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXmlaHierarchy
implements JROlapHierarchy {
    private static final Log log = LogFactory.getLog(JRXmlaHierarchy.class);
    public static final String EXCEPTION_MESSAGE_KEY_XMLA_INVALID_DIMENSION_HIERARCHY = "data.olap.xmla.invalid.dimension.hierarchy";
    private static final Pattern DIMENSION_HIERARCHY_PATTERN = Pattern.compile("\\[.*\\]\\.\\[.*\\]");
    private final String dimensionName;
    private final String uniqueName;
    private final List<JRXmlaHierarchyLevel> levels;
    private JRXmlaHierarchyLevel[] levelArray;

    public JRXmlaHierarchy(String dimensionName) {
        this.dimensionName = dimensionName;
        this.uniqueName = this.parseUniqueName(dimensionName);
        this.levels = new ArrayList<JRXmlaHierarchyLevel>();
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public JROlapHierarchyLevel[] getLevels() {
        return this.ensureLevelArray();
    }

    public void setLevel(String levelName, int depth) {
        JRXmlaHierarchyLevel level;
        int levelCount = this.levels.size();
        if (depth >= levelCount) {
            for (int i = levelCount; i <= depth; ++i) {
                this.levels.add(null);
            }
        }
        if ((level = this.levels.get(depth)) == null) {
            level = new JRXmlaHierarchyLevel(levelName, depth);
            this.levels.set(depth, level);
        } else if (!levelName.equals(level.getName()) && log.isWarnEnabled()) {
            log.warn("Different level name \"" + levelName + "\" found for level \"" + level.getName() + "\" at depth " + depth);
        }
        this.resetLevelArray();
    }

    @Override
    public String getHierarchyUniqueName() {
        return this.uniqueName;
    }

    protected JRXmlaHierarchyLevel[] ensureLevelArray() {
        if (this.levelArray == null) {
            this.levelArray = new JRXmlaHierarchyLevel[this.levels.size()];
            this.levelArray = this.levels.toArray(this.levelArray);
        }
        return this.levelArray;
    }

    protected void resetLevelArray() {
        this.levelArray = null;
    }

    protected String parseUniqueName(String originalDimensionName) {
        Matcher m = DIMENSION_HIERARCHY_PATTERN.matcher(originalDimensionName);
        Boolean gotMatch = m.matches();
        if (gotMatch.booleanValue()) {
            int startIndex = originalDimensionName.lastIndexOf(".[");
            int endIndex = originalDimensionName.lastIndexOf(93);
            if (startIndex == -1 || endIndex == -1 || startIndex + 3 >= endIndex) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_XMLA_INVALID_DIMENSION_HIERARCHY, originalDimensionName);
            }
            return originalDimensionName.substring(startIndex + 2, endIndex);
        }
        return originalDimensionName;
    }
}

