/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.phantomjs;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.phantomjs.PhantomJSProcess;
import net.sf.jasperreports.phantomjs.ProcessDirector;
import net.sf.jasperreports.phantomjs.RequestTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class ProcessConnection {
    private static final Log log = LogFactory.getLog(ProcessConnection.class);
    private PhantomJSProcess process;
    private CloseableHttpClient httpClient;

    public ProcessConnection(ProcessDirector director, PhantomJSProcess process) {
        this.process = process;
        HttpClientBuilder clientBuilder = HttpClients.custom();
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager();
        clientBuilder.setConnectionManager(connManager);
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setSocketTimeout(director.getRequestTimeout()).build();
        clientBuilder.setDefaultRequestConfig(requestConfig);
        this.httpClient = clientBuilder.build();
    }

    public String runRequest(String data) {
        String string;
        block22: {
            HttpPost httpPost = new HttpPost(this.process.getListenURI());
            ByteArrayEntity postEntity = new ByteArrayEntity(data.getBytes(StandardCharsets.UTF_8));
            httpPost.setEntity(postEntity);
            if (log.isDebugEnabled()) {
                log.debug(this.process.getId() + " executing HTTP at " + this.process.getListenURI());
            }
            CloseableHttpResponse response = this.httpClient.execute(httpPost);
            try {
                byte[] responseData;
                HttpEntity entity;
                StatusLine status = response.getStatusLine();
                if (log.isDebugEnabled()) {
                    log.debug(this.process.getId() + " HTTP response status " + status);
                }
                if ((entity = response.getEntity()) == null) {
                    throw new JRRuntimeException("Empty from PhantomJS");
                }
                if (status.getStatusCode() >= 300) {
                    if (entity.getContentType() != null && entity.getContentType().getValue() != null && entity.getContentType().getValue().startsWith("text/plain")) {
                        String responseContents = EntityUtils.toString(entity, StandardCharsets.UTF_8);
                        log.error("PhantomJS process " + this.process.getId() + " error: " + responseContents);
                    } else {
                        EntityUtils.consumeQuietly(entity);
                    }
                    throw new JRRuntimeException("Unexpected status " + status + " from PhantomJS");
                }
                try (InputStream responseStream = entity.getContent();){
                    responseData = JRLoader.loadBytes(responseStream);
                }
                string = new String(responseData, StandardCharsets.UTF_8);
                if (response == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SocketTimeoutException e) {
                    log.error(this.process.getId() + " request timed out");
                    throw new RequestTimeoutException(e);
                }
                catch (IOException | JRException e) {
                    throw new JRRuntimeException(e);
                }
            }
            response.close();
        }
        return string;
    }

    public void dispose() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            log.warn(this.process.getId() + " failed to close HttpClient", e);
        }
    }
}

