/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.util.JacksonMapping;
import net.sf.jasperreports.util.JacksonRuntimException;

public class JacksonUtil {
    private static final String OBJECT_MAPPER_CONTEXT_KEY = "net.sf.jasperreports.jackson.object.mapper";
    private static final String XML_MAPPER_CONTEXT_KEY = "net.sf.jasperreports.jackson.xml.mapper";
    private JasperReportsContext jasperReportsContext;

    protected JacksonUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static JacksonUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new JacksonUtil(jasperReportsContext);
    }

    public ObjectMapper getObjectMapper() {
        ObjectMapper mapper = (ObjectMapper)this.jasperReportsContext.getOwnValue(OBJECT_MAPPER_CONTEXT_KEY);
        if (mapper == null) {
            mapper = new ObjectMapper();
            List<JacksonMapping> jacksonMappings = this.jasperReportsContext.getExtensions(JacksonMapping.class);
            for (JacksonMapping jacksonMapping : jacksonMappings) {
                JacksonUtil.register(mapper, jacksonMapping);
            }
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            this.jasperReportsContext.setValue(OBJECT_MAPPER_CONTEXT_KEY, mapper);
        }
        return mapper;
    }

    public XmlMapper getXmlMapper() {
        XmlMapper mapper = (XmlMapper)this.jasperReportsContext.getOwnValue(XML_MAPPER_CONTEXT_KEY);
        if (mapper == null) {
            mapper = new XmlMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            List<JacksonMapping> jacksonMappings = this.jasperReportsContext.getExtensions(JacksonMapping.class);
            for (JacksonMapping jacksonMapping : jacksonMappings) {
                JacksonUtil.register(mapper, jacksonMapping);
            }
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            this.jasperReportsContext.setValue(XML_MAPPER_CONTEXT_KEY, mapper);
        }
        return mapper;
    }

    private static void register(ObjectMapper mapper, JacksonMapping mapping) {
        try {
            Class<?> clazz = Class.forName(mapping.getClassName());
            mapper.registerSubtypes(new NamedType(clazz, mapping.getName()));
        }
        catch (ClassNotFoundException e) {
            throw new JRRuntimeException(e);
        }
    }

    public <T> T loadObject(String jsonData, Class<T> clazz) {
        T result = null;
        if (jsonData != null) {
            ObjectMapper mapper = this.getObjectMapper();
            try {
                result = mapper.readValue(jsonData, clazz);
            }
            catch (JsonProcessingException e) {
                throw new JRRuntimeException(e);
            }
        }
        return result;
    }

    public <T> T loadXml(String xmlData, Class<T> clazz) {
        T result = null;
        if (xmlData != null) {
            XmlMapper mapper = this.getXmlMapper();
            try {
                result = mapper.readValue(xmlData, clazz);
            }
            catch (JsonProcessingException e) {
                throw new JRRuntimeException(e);
            }
        }
        return result;
    }

    public <T> T loadXml(InputStream is, Class<T> clazz) {
        T result = null;
        if (is != null) {
            XmlMapper mapper = this.getXmlMapper();
            try {
                result = mapper.readValue(is, clazz);
            }
            catch (JacksonException e) {
                throw new JacksonRuntimException(e);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        return result;
    }

    public <T> List<T> loadList(String jsonData, Class<T> clazz) {
        List result = null;
        if (jsonData != null) {
            ObjectMapper mapper = this.getObjectMapper();
            try {
                result = (List)mapper.readValue(jsonData, mapper.getTypeFactory().constructParametricType(List.class, clazz));
            }
            catch (JsonParseException e) {
                throw new JRRuntimeException(e);
            }
            catch (JsonMappingException e) {
                throw new JRRuntimeException(e);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        return result;
    }

    public <T> List<T> loadAsList(String jsonData, Class<T> clazz) {
        List<T> result = null;
        if (jsonData != null) {
            String trimmedData = jsonData.trim();
            if (trimmedData.startsWith("{")) {
                result = new ArrayList<T>();
                result.add(this.loadObject(trimmedData, clazz));
            } else if (trimmedData.startsWith("[")) {
                result = this.loadList(trimmedData, clazz);
            }
        }
        return result;
    }

    public String getJsonString(Object object) {
        ObjectMapper mapper = this.getObjectMapper();
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonGenerationException e) {
            throw new JRRuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public String getXmlString(Object object) {
        XmlMapper mapper = this.getXmlMapper();
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonGenerationException e) {
            throw new JRRuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public String getEscapedJsonString(Object object) {
        return this.getJsonString(object).replaceAll("\\\"", "\\\\\\\"");
    }

    public ObjectNode hyperlinkToJsonObject(JRPrintHyperlink hyperlink) {
        ObjectNode hyperlinkNode = this.getObjectMapper().createObjectNode();
        this.addProperty(hyperlinkNode, "type", hyperlink.getLinkType());
        this.addProperty(hyperlinkNode, "typeValue", hyperlink.getHyperlinkTypeValue().getName());
        this.addProperty(hyperlinkNode, "target", hyperlink.getLinkTarget());
        this.addProperty(hyperlinkNode, "targetValue", hyperlink.getHyperlinkTargetValue().getHtmlValue(), hyperlink.getLinkTarget());
        this.addProperty(hyperlinkNode, "tooltip", hyperlink.getHyperlinkTooltip());
        this.addProperty(hyperlinkNode, "anchor", hyperlink.getHyperlinkAnchor());
        this.addProperty(hyperlinkNode, "page", String.valueOf(hyperlink.getHyperlinkPage()));
        this.addProperty(hyperlinkNode, "reference", hyperlink.getHyperlinkReference());
        JRPrintHyperlinkParameters hParams = hyperlink.getHyperlinkParameters();
        if (hParams != null && hParams.getParameters().size() > 0) {
            ObjectNode params = this.getObjectMapper().createObjectNode();
            for (JRPrintHyperlinkParameter hParam : hParams.getParameters()) {
                if (hParam.getValue() == null) continue;
                if (Collection.class.isAssignableFrom(hParam.getValue().getClass())) {
                    ArrayNode paramValues = this.getObjectMapper().createArrayNode();
                    Collection col = (Collection)hParam.getValue();
                    for (Object next : col) {
                        paramValues.add(JRValueStringUtils.serialize(next.getClass().getName(), next));
                    }
                    params.set(hParam.getName(), paramValues);
                    continue;
                }
                params.put(hParam.getName(), JRValueStringUtils.serialize(hParam.getValueClass(), hParam.getValue()));
            }
            hyperlinkNode.set("params", params);
        }
        return hyperlinkNode;
    }

    public void addProperty(ObjectNode objectNode, String property, String value) {
        this.addProperty(objectNode, property, value, null);
    }

    public void addProperty(ObjectNode objectNode, String property, String value, String altValue) {
        if (value != null && !value.equals("null")) {
            objectNode.put(property, value);
        } else if (altValue != null && !altValue.equals("null")) {
            objectNode.put(property, altValue);
        }
    }
}

