/*
 * Decompiled with CFR 0.152.
 */
package com.towel.role;

import com.towel.cfg.StringConfiguration;
import com.towel.role.Role;
import com.towel.role.RoleMember;
import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;

public class RoleManager {
    private RoleMember member;

    public RoleManager(RoleMember role) {
        this.member = role;
    }

    public void manageAnnotated(Object instance) {
        for (Map.Entry<Field, Role> ent : this.mapComps(instance.getClass()).entrySet()) {
            if (ent.getValue().visibleTo().contains(this.member.getRoleName())) continue;
            try {
                Field f = ent.getKey();
                f.setAccessible(true);
                ((Component)f.get(instance)).setVisible(false);
            }
            catch (Exception exception) {}
        }
    }

    public void manageNamedComps(Container cont) {
        for (Map.Entry<Component, String> ent : this.mapComps(cont, null).entrySet()) {
            if (new StringConfiguration(ent.getValue()).getAttribute("visibleTo").contains(this.member.getRoleName())) continue;
            ent.getKey().setVisible(false);
        }
    }

    private Map<Component, String> mapComps(Container cont, Map<Component, String> mapped) {
        Component[] components;
        if (mapped == null) {
            mapped = new HashMap<Component, String>();
        }
        for (Component comp : components = cont.getComponents()) {
            if (comp instanceof Component && comp.getName() != null && comp.getName().length() != 0 && !comp.getName().startsWith("null")) {
                mapped.put(comp, comp.getName());
            }
            if (comp instanceof JMenu) {
                this.mapJMenu((JMenu)comp, mapped);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.mapComps((Container)comp, mapped);
        }
        return mapped;
    }

    private void mapJMenu(JMenu menu, Map<Component, String> mapped) {
        Component[] menuComponents;
        for (Component comp : menuComponents = menu.getMenuComponents()) {
            if (comp instanceof Component && comp.getName() != null && comp.getName().length() != 0 && !comp.getName().startsWith("null")) {
                mapped.put(comp, comp.getName());
            }
            if (comp instanceof JMenu) {
                this.mapJMenu((JMenu)comp, mapped);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.mapComps((Container)comp, mapped);
        }
    }

    private Map<Field, Role> mapComps(Class<?> view) {
        Field[] declaredFields;
        HashMap<Field, Role> mapped = new HashMap<Field, Role>();
        for (Field field : declaredFields = view.getDeclaredFields()) {
            if (!Component.class.isAssignableFrom(field.getType()) || !field.isAnnotationPresent(Role.class)) continue;
            mapped.put(field, field.getAnnotation(Role.class));
        }
        return mapped;
    }
}

