/*
 * Decompiled with CFR 0.152.
 */
package com.towel.sound;

import com.towel.sound.Sampled;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Sound
implements Sampled {
    private AudioFormat format;
    private byte[] samples = null;

    public Sound(URL resource) throws UnsupportedAudioFileException, IOException {
        this(AudioSystem.getAudioInputStream(resource));
    }

    public Sound(File file) throws UnsupportedAudioFileException, IOException {
        this(AudioSystem.getAudioInputStream(file));
    }

    public Sound(String fileName) throws UnsupportedAudioFileException, IOException {
        this(new File(fileName));
    }

    public Sound(AudioInputStream stream) throws IOException {
        this.setSamples(this.getSamplesFromAudio(stream));
        this.format = stream.getFormat();
    }

    public byte[] getSamplesFromAudio(AudioInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("You must provide an AudioInputStream!");
        }
        byte[] samples2 = new byte[(int)(stream.getFrameLength() * (long)stream.getFormat().getFrameSize())];
        new DataInputStream(stream).readFully(samples2);
        return samples2;
    }

    public void setSamples(byte[] samples2) {
        if (samples2 == null) {
            throw new IllegalArgumentException("You must provide some samples!");
        }
        this.samples = samples2;
    }

    @Override
    public byte[] getSamples() {
        return this.samples;
    }

    @Override
    public InputStream newInputStream() {
        return new ByteArrayInputStream(this.samples);
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }
}

