/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.UIManager;

public class ButtonLabel
extends AbstractButton {
    private String text;
    private int height;

    public ButtonLabel(String text) {
        super.setText(text);
        super.addMouseListener(new MouseClick());
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setFont(UIManager.getFont("TitledBorder.font"));
            g2d.setColor(this.getColor());
            g2d.drawString(this.text, 0, (this.height + 6) / 2);
            g2d.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.updateSize();
    }

    private void updateSize() {
        FontMetrics metrics = this.getFontMetrics(UIManager.getFont("TitledBorder.font"));
        this.height = metrics.getHeight();
        this.setPreferredSize(new Dimension(metrics.stringWidth(this.getText()), this.height));
    }

    private Color getColor() {
        return UIManager.getColor("TitledBorder.titleColor");
    }

    private class MouseClick
    extends MouseAdapter {
        private MouseClick() {
        }

        @Override
        public void mouseClicked(MouseEvent evnt) {
            for (ActionListener listener : ButtonLabel.this.getActionListeners()) {
                listener.actionPerformed(new ActionEvent(ButtonLabel.this, 0, ""));
            }
        }

        @Override
        public void mouseEntered(MouseEvent evnt) {
            if (ButtonLabel.this.getActionListeners().length == 0) {
                return;
            }
            ButtonLabel.this.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent evnt) {
            ButtonLabel.this.setCursor(new Cursor(0));
        }
    }
}

