/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;

public class GuiUtils {
    public static void scrollToVisible(JTable table, int rowIndex) {
        GuiUtils.scrollToVisible(table, rowIndex, 0);
    }

    public static void scrollToVisible(JTable table, int rowIndex, int vColIndex) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        GuiUtils.setViewPortPosition((JViewport)table.getParent(), table.getCellRect(rowIndex, vColIndex, true));
    }

    public static Collection<Integer> getReverseSelectedRows(JTable table) {
        TreeSet<Integer> rows = new TreeSet<Integer>((o1, o2) -> o2.compareTo((Integer)o1));
        for (int r : table.getSelectedRows()) {
            rows.add(r);
        }
        return rows;
    }

    public static void selectAndScroll(JTable table, int rowIndex) {
        table.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
        GuiUtils.scrollToVisible(table, rowIndex);
    }

    public static void scrollToSelection(JTree tree) {
        if (!(tree.getParent() instanceof JViewport)) {
            return;
        }
        GuiUtils.setViewPortPosition((JViewport)tree.getParent(), tree.getPathBounds(tree.getSelectionPath()));
    }

    private static void setViewPortPosition(JViewport viewport, Rectangle position) {
        Point pt = viewport.getViewPosition();
        position.setLocation(position.x - pt.x, position.y - pt.y);
        viewport.scrollRectToVisible(position);
    }

    public static void expandAllNodes(JTree tree) {
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }

    public static void expandFirstNodes(JTree tree) {
        for (int i = tree.getRowCount() - 1; i >= 0; --i) {
            tree.expandRow(i);
        }
    }

    public static String encodeColor(Color color) {
        if (color == null) {
            return "000000";
        }
        return String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Component getOwnerWindow(Component component) {
        Component parent;
        for (parent = component; parent != null && !(parent instanceof Frame) && !(parent instanceof Dialog); parent = parent.getParent()) {
        }
        return parent;
    }
}

