/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing;

import java.awt.FontMetrics;
import java.awt.Point;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class TextUtils {
    public static int getCaretLine(JTextComponent txtCmp) {
        return TextUtils.getLine(txtCmp.getDocument(), txtCmp.getCaretPosition());
    }

    public static int getLine(JTextComponent txtCmp, int offset) {
        return TextUtils.getLine(txtCmp.getDocument(), offset);
    }

    public static int getLine(Document doc, int offset) {
        Element root = doc.getDefaultRootElement();
        return root.getElementIndex(offset);
    }

    public static int getCaretColumn(JTextComponent txtCmp) {
        return TextUtils.getColumn(txtCmp, txtCmp.getCaretPosition());
    }

    public static int getColumn(JTextComponent txtCmp, int offset) {
        return txtCmp.getCaretPosition() - TextUtils.getOffsetStartLine(txtCmp, offset);
    }

    public static int getOffsetStartLine(JTextComponent txtCmp, int offset) {
        return TextUtils.getOffsetStartLine(txtCmp.getDocument(), offset);
    }

    public static int getOffsetStartLine(Document doc, int offset) {
        int line = TextUtils.getLine(doc, offset);
        return TextUtils.getWhereLineStarts(doc, line);
    }

    public static int getOffsetEndLine(JTextComponent txtCmp, int offset) {
        return TextUtils.getOffsetEndLine(txtCmp.getDocument(), offset);
    }

    public static int getOffsetEndLine(Document doc, int offset) {
        int line = TextUtils.getLine(doc, offset);
        return TextUtils.getWhereLineEnds(doc, line);
    }

    public static int getWhereLineStarts(JTextComponent txtCmp, int line) {
        return TextUtils.getWhereLineStarts(txtCmp.getDocument(), line);
    }

    public static int getWhereLineStarts(Document doc, int line) {
        Element el = doc.getDefaultRootElement().getElement(line);
        if (el != null) {
            return el.getStartOffset();
        }
        return doc.getStartPosition().getOffset();
    }

    public static int getWhereLineEnds(JTextComponent txtCmp, int line) {
        return TextUtils.getWhereLineEnds(txtCmp.getDocument(), line);
    }

    public static int getWhereLineEnds(Document doc, int line) {
        Element el = doc.getDefaultRootElement().getElement(line);
        if (el != null) {
            return el.getEndOffset();
        }
        return doc.getEndPosition().getOffset();
    }

    public static int countLines(JTextComponent txtCmp) {
        return TextUtils.countLines(txtCmp.getDocument());
    }

    public static int countLines(Document doc) {
        return doc.getDefaultRootElement().getElementCount();
    }

    public static int getRows(JTextComponent txtCmp) {
        FontMetrics fm = txtCmp.getFontMetrics(txtCmp.getFont());
        int fontHeight = fm.getHeight();
        int ybaseline = txtCmp.getY() + fm.getAscent();
        int yend = ybaseline + txtCmp.getHeight();
        int rows = 1;
        while (ybaseline < yend) {
            ybaseline += fontHeight;
            ++rows;
        }
        return rows;
    }

    public static int getTopLine(JTextComponent txtCmp) {
        FontMetrics fm = txtCmp.getFontMetrics(txtCmp.getFont());
        int fontHeight = fm.getHeight();
        return (Math.abs(txtCmp.getY()) + fm.getAscent()) / fontHeight + 1;
    }

    public static int getBottomLine(JTextComponent txtCmp) {
        FontMetrics fm = txtCmp.getFontMetrics(txtCmp.getFont());
        int fontHeight = fm.getHeight();
        View view = txtCmp.getUI().getRootView(txtCmp).getView(0);
        int height = view.getContainer().getParent().getHeight();
        return (Math.abs(txtCmp.getY()) + fm.getAscent() + height) / fontHeight;
    }

    public static void scrollToVisible(JScrollPane scroll, int offset) {
        if (!(scroll.getViewport().getView() instanceof JTextComponent)) {
            return;
        }
        JTextComponent txtCmp = (JTextComponent)scroll.getViewport().getView();
        Element root = txtCmp.getDocument().getDefaultRootElement();
        int line = root.getElementIndex(offset);
        TextUtils.scrollLineToVisible(scroll, line);
    }

    public static void scrollLineToVisible(JScrollPane scroll, int line) {
        if (!(scroll.getViewport().getView() instanceof JTextComponent)) {
            return;
        }
        JTextComponent txtCmp = (JTextComponent)scroll.getViewport().getView();
        FontMetrics fm = txtCmp.getFontMetrics(txtCmp.getFont());
        int fontHeight = fm.getHeight();
        scroll.getViewport().setViewPosition(new Point(0, fontHeight * line));
    }

    public static String generateEscapeRegex(String text) {
        text = text.replaceAll("\\\\", "\\\\\\\\");
        text = text.replaceAll("\\.", "\\\\.");
        text = text.replaceAll("\\*", "\\\\*");
        text = text.replaceAll("\\?", "\\\\?");
        text = text.replaceAll("\\(", "\\\\(");
        text = text.replaceAll("\\)", "\\\\)");
        text = text.replaceAll("\\[", "\\\\[");
        text = text.replaceAll("\\]", "\\\\]");
        text = text.replaceAll("\\{", "\\\\{");
        text = text.replaceAll("\\}", "\\\\}");
        text = text.replaceAll("\\^", "\\\\^");
        text = text.replaceAll("\\$", "\\\\\\$");
        text = text.replaceAll("\\+", "\\\\+");
        text = text.replaceAll("\\|", "\\\\|");
        return text;
    }
}

