/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing.scroll;

import com.towel.collections.ListNavigator;
import com.towel.collections.Navigator;
import com.towel.swing.scroll.ScrollEvent;
import com.towel.swing.scroll.ScrollEventListener;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class ScrollBar<T>
extends JPanel {
    private T currentValue;
    private Navigator<T> data;
    private List<ScrollEventListener> listeners = new ArrayList<ScrollEventListener>();

    public ScrollBar() {
        this.setBorder(new LineBorder(Color.BLACK, 1));
        this.setLayout(new FlowLayout());
        JButton previous = new JButton("<");
        JButton next = new JButton("<");
        previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollBar.this.currentValue = ScrollBar.this.data.previous();
                ScrollBar.this.fireScrollEvent();
            }
        });
        next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ScrollBar.this.currentValue = ScrollBar.this.data.next();
                ScrollBar.this.fireScrollEvent();
            }
        });
        this.add(previous);
        this.add(next);
    }

    public void setData(List<T> list) {
        this.data = new ListNavigator<T>(list);
    }

    public void setData(Navigator<T> navigator) {
        this.data = navigator;
    }

    public void addScrollEventListener(ScrollEventListener listener) {
        this.listeners.add(listener);
    }

    public void fireScrollEvent() {
        ScrollEvent event = new ScrollEvent(this.currentValue, this);
        for (ScrollEventListener listener : this.listeners) {
            listener.scrollPerformed(event);
        }
    }

    public T getCurrentValue() {
        return this.currentValue;
    }
}

