/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing.separator;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class TitledSeparator
extends JLabel {
    public TitledSeparator(String text) {
        super.setText(text);
        super.setFocusable(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        TitledSeparator.super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        int startX = this.getFontMetrics(this.getTitleFont()).stringWidth(this.getText()) + 5;
        int half = this.getSize().height / 2;
        g2d.drawLine(startX, half, this.getSize().width, half);
        g2d.dispose();
    }

    @Override
    public void updateUI() {
        TitledSeparator.super.updateUI();
        Color foreground = this.getTitleColor();
        if (foreground != null) {
            this.setForeground(foreground);
        }
        this.setFont(this.getTitleFont());
    }

    private Color getTitleColor() {
        return UIManager.getColor("TitledBorder.titleColor");
    }

    private Font getTitleFont() {
        return UIManager.getFont("TitledBorder.font");
    }
}

