/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing.splash;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow {
    private JProgressBar bar;
    private JLabel label;

    public SplashScreen(final BufferedImage img) {
        JProgressBar jProgressBar;
        JLabel jLabel;
        JPanel panel = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.create().drawImage(img, 0, 0, img.getWidth(), img.getHeight(), SplashScreen.this);
            }
        };
        panel.setPreferredSize(new Dimension(img.getWidth(), img.getHeight()));
        Container content = super.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)panel, "North");
        this.label = jLabel = new JLabel();
        content.add((Component)jLabel, "Center");
        this.bar = jProgressBar = new JProgressBar();
        content.add((Component)jProgressBar, "South");
        super.setLocationRelativeTo(null);
    }

    public void setMessage(String msg) {
        this.label.setText(msg);
        this.pack();
    }

    public void setProgress(int prog) {
        this.bar.setValue(prog);
    }

    public void setIndeterminateProgress(boolean value) {
        this.bar.setIndeterminate(value);
    }
}

