/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing.table.headerpopup;

import com.towel.swing.table.headerpopup.HeaderPopupEvent;
import com.towel.swing.table.headerpopup.HeaderPopupListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.table.JTableHeader;

public class HeaderPopup
extends JPopupMenu {
    private JTableHeader header = null;
    private JList list = null;
    private PopupListModel listModel;
    private int modelndex;
    private JScrollPane scrPane = null;

    public HeaderPopup(JTableHeader header2, int modelIndex) {
        this.header = header2;
        this.modelndex = modelIndex;
        this.listModel = new PopupListModel(null);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(new LineBorder(Color.BLACK, 1));
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
        this.add(this.getScrPane());
    }

    private JScrollPane getScrPane() {
        if (this.scrPane == null) {
            this.scrPane = new JScrollPane(this.getList(), 20, 31);
            this.scrPane.getVerticalScrollBar().setFocusable(false);
            this.scrPane.setFocusable(false);
            this.scrPane.setBorder(null);
        }
        return this.scrPane;
    }

    private JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setModel(this.listModel);
            this.list.setFont(this.header.getFont());
            this.list.setForeground(this.header.getForeground());
            this.list.setBackground(this.header.getBackground());
            this.list.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
            this.list.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
            this.list.setBorder(null);
            this.list.setFocusable(false);
            this.list.setSelectionMode(0);
            this.list.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (e.getSource() == HeaderPopup.this.list) {
                        HeaderPopup.this.updateListBoxSelectionForEvent(e);
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Element element = (Element)HeaderPopup.this.list.getSelectedValue();
                    if (element != null) {
                        element.listener.elementSelected(new HeaderPopupEvent(element.getObject(), HeaderPopup.this.modelndex));
                        HeaderPopup.this.setVisible(false);
                    }
                }
            });
            this.list.setCellRenderer(new DefaultListCellRenderer(){
                private final Component SEPARATOR = new SeparatorComponent(null);

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (value == null) {
                        return this.SEPARATOR;
                    }
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
            });
        }
        return this.list;
    }

    private void updateListBoxSelectionForEvent(MouseEvent e) {
        int index;
        Point location = e.getPoint();
        Rectangle r = new Rectangle();
        this.list.computeVisibleRect(r);
        if (r.contains(location) && this.list != null && (index = this.list.locationToIndex(location)) != -1) {
            if (this.listModel.get(index) == null) {
                ++index;
            }
            if (this.list.getSelectedIndex() != index) {
                this.list.setSelectedIndex(index);
            }
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public void show(int columnIndex) {
        Dimension d;
        this.list.clearSelection();
        Rectangle rect = this.header.getHeaderRect(columnIndex);
        if (rect.getWidth() < 180.0) {
            d = new Dimension(180, (int)this.list.getPreferredSize().getHeight());
            if ((double)((int)(rect.getX() - 1.0)) - (180.0 - rect.getWidth()) > 0.0) {
                rect.setBounds((int)(rect.getX() - 1.0 - (180.0 - rect.getWidth())), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            } else {
                rect.setBounds(0, (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            }
        } else {
            d = new Dimension((int)rect.getWidth() - 1, (int)this.list.getPreferredSize().getHeight());
        }
        if (d.height > 300) {
            d.height = 300;
        }
        this.scrPane.setPreferredSize(d);
        this.scrPane.setMinimumSize(d);
        this.scrPane.setMaximumSize(d);
        HeaderPopup.super.show(this.header, (int)rect.getX() - 1, (int)(rect.getY() + rect.getHeight()) - 1);
    }

    public int getModelIndex() {
        return this.modelndex;
    }

    public void addElement(Object element, HeaderPopupListener listener) {
        this.listModel.add(new Element(element, listener));
    }

    public void removeElement(Object element) {
        this.listModel.remove(new Element(element, null));
    }

    public void removeAllElements() {
        this.listModel.removeAllElements();
    }

    public boolean isEmpty() {
        return this.listModel.isEmpty();
    }

    public void addListSeparator() {
        this.listModel.add(null);
    }

    private class Element {
        private HeaderPopupListener listener;
        private Object obj;

        public Element(Object obj2, HeaderPopupListener listener2) {
            this.obj = obj2;
            this.listener = listener2;
        }

        public HeaderPopupListener getListener() {
            return this.listener;
        }

        public Object getObject() {
            return this.obj;
        }

        public String toString() {
            if (this.obj == null) {
                return "";
            }
            return this.obj.toString();
        }

        public boolean equals(Object obj2) {
            if (obj2 == null) {
                return false;
            }
            if (obj2 == this) {
                return true;
            }
            if (!(obj2 instanceof Element)) {
                return false;
            }
            Element other = (Element)obj2;
            if (this.obj == other.obj) {
                return true;
            }
            if (this.obj == null || other.obj == null) {
                return false;
            }
            return this.obj.equals(((Element)obj2).getObject());
        }

        public int hashCode() {
            return this.obj.hashCode();
        }
    }

    private static class SeparatorComponent
    extends JComponent {
        private static final int LINE_POS = 4;
        private static final Dimension PREFERRED_SIZE = new Dimension(5, 9);

        private SeparatorComponent() {
            super.setOpaque(false);
        }

        SeparatorComponent(SeparatorComponent separatorComponent) {
            this();
        }

        @Override
        public Dimension getPreferredSize() {
            return PREFERRED_SIZE;
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(Color.BLACK);
            g.drawLine(0, 4, this.getWidth(), 4);
        }
    }

    public static class PopupListModel
    extends AbstractListModel {
        private List<Object> elements = new ArrayList<Object>();

        private PopupListModel() {
        }

        PopupListModel(PopupListModel popupListModel) {
            this();
        }

        @Override
        public Object getElementAt(int index) {
            return this.elements.get(index);
        }

        @Override
        public int getSize() {
            return this.elements.size();
        }

        public void add(Object o) {
            this.elements.add(o);
            this.fireIntervalAdded(this, this.elements.indexOf(o), this.elements.indexOf(o));
        }

        public void remove(Object o) {
            int index = this.elements.indexOf(o);
            this.elements.remove(o);
            this.fireIntervalRemoved(this, index, index);
        }

        public void removeAllElements() {
            int size = this.elements.size();
            this.elements.clear();
            if (size > 0) {
                this.fireIntervalRemoved(this, 0, size - 1);
            }
        }

        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        public Object get(int index) {
            return this.elements.get(index);
        }
    }
}

