/*
 * Decompiled with CFR 0.152.
 */
package com.towel.swing.tooltip;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatDropShadowBorder;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class Tooltip
extends JPanel {
    private JPanel popup;
    private int position;
    private JComponent component;
    private boolean onPressedShowing = false;
    private JLabel jlMessage;

    public static Tooltip build(String message, JComponent component) {
        Tooltip pm = new Tooltip(message, component);
        return pm;
    }

    public static Tooltip build(String message, int position, JComponent component) {
        Tooltip pm = new Tooltip(message, position, component);
        return pm;
    }

    public static Tooltip build(String message, int position, JComponent component, boolean showMoveOrPressed) {
        Tooltip pm = new Tooltip(message, position, component, showMoveOrPressed);
        return pm;
    }

    public Tooltip(String message, JComponent component) {
        this(message, 4, component, true);
    }

    public Tooltip(String message, int position, JComponent component) {
        this(message, position, component, true);
    }

    public Tooltip(String message, int position, JComponent component, boolean showMoveOrPressed) {
        this.initComponents();
        this.component = component;
        this.position = position;
        if (showMoveOrPressed) {
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    Tooltip.this.showPopup();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    Tooltip.this.hidePopup();
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    Tooltip.this.hidePopup();
                }
            });
        } else {
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (Tooltip.this.onPressedShowing) {
                        Tooltip.this.hidePopup();
                    } else {
                        Tooltip.this.showPopup();
                    }
                    Tooltip.this.onPressedShowing = !Tooltip.this.onPressedShowing;
                }
            });
        }
        this.jlMessage.setText("<html>" + message + "</html>");
        this.jlMessage.setFont(new Font("Segoe UI", 0, 12));
        this.setOpaque(false);
        this.updateBalloonBorder();
    }

    public void setText(String message) {
        this.jlMessage.setText("<html>" + message + "</html>");
    }

    public void setPosition(int position) {
        this.position = position;
        this.updateBalloonBorder();
        this.repaint();
    }

    void showPopup() {
        JRootPane rootPane = SwingUtilities.getRootPane(this.component);
        if (rootPane == null) {
            return;
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        this.popup = new JPanel(new BorderLayout()){

            @Override
            public void updateUI() {
                super.updateUI();
                EventQueue.invokeLater(() -> {
                    this.validate();
                    this.setSize(this.getPreferredSize());
                });
            }
        };
        this.popup.setOpaque(false);
        this.popup.add(this);
        Point pt = SwingUtilities.convertPoint(this.component, 0, 0, layeredPane);
        int x = pt.x;
        int y = pt.y;
        Dimension size = this.popup.getPreferredSize();
        int gap = UIScale.scale((int)6);
        switch (this.position) {
            case 2: {
                x -= size.width + gap;
                break;
            }
            case 1: {
                y -= size.height + gap;
                break;
            }
            case 4: {
                x += this.component.getWidth() + gap;
                break;
            }
            case 3: {
                y += this.component.getHeight() + gap;
            }
        }
        this.popup.setBounds(x, y, size.width, size.height);
        layeredPane.add((Component)this.popup, JLayeredPane.POPUP_LAYER);
    }

    void hidePopup() {
        Container parent;
        if (this.popup != null && (parent = this.popup.getParent()) != null) {
            parent.remove(this.popup);
            parent.repaint(this.popup.getX(), this.popup.getY(), this.popup.getWidth(), this.popup.getHeight());
        }
    }

    private void initComponents() {
        this.jlMessage = new JLabel();
        this.setLayout(new BorderLayout());
        this.jlMessage.setText("popover message");
        this.jlMessage.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.jlMessage, "Center");
    }

    public void setMessageForeground(Color fg) {
        if (fg != null) {
            this.jlMessage.setForeground(fg);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (UIManager.getLookAndFeel() instanceof FlatLaf) {
            this.setBackground(UIManager.getColor("HintPanel.backgroundColor"));
        } else {
            this.setBackground(FlatUIUtils.nonUIResource((Color)UIManager.getColor("info")));
        }
    }

    private void updateBalloonBorder() {
        int direction;
        switch (this.position) {
            case 2: {
                direction = 4;
                break;
            }
            case 1: {
                direction = 3;
                break;
            }
            case 4: {
                direction = 2;
                break;
            }
            case 3: {
                direction = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.setBorder((Border)((Object)new BalloonBorder(direction, FlatUIUtils.getUIColor((String)"PopupMenu.borderColor", (Color)Color.gray))));
    }

    private static class BalloonBorder
    extends FlatEmptyBorder {
        private static int ARC = 8;
        private static int ARROW_XY = 16;
        private static int ARROW_SIZE = 8;
        private static int SHADOW_SIZE = 6;
        private static int SHADOW_TOP_SIZE = 3;
        private static int SHADOW_SIZE2 = SHADOW_SIZE + 2;
        private final int direction;
        private final Color borderColor;
        private final Border shadowBorder;

        public BalloonBorder(int direction, Color borderColor) {
            super(1 + SHADOW_TOP_SIZE, 1 + SHADOW_SIZE, 1 + SHADOW_SIZE, 1 + SHADOW_SIZE);
            this.direction = direction;
            this.borderColor = borderColor;
            switch (direction) {
                case 2: {
                    this.left += ARROW_SIZE;
                    break;
                }
                case 1: {
                    this.top += ARROW_SIZE;
                    break;
                }
                case 4: {
                    this.right += ARROW_SIZE;
                    break;
                }
                case 3: {
                    this.bottom += ARROW_SIZE;
                }
            }
            this.shadowBorder = UIManager.getLookAndFeel() instanceof FlatLaf ? new FlatDropShadowBorder(UIManager.getColor("Popup.dropShadowColor"), new Insets(SHADOW_SIZE2, SHADOW_SIZE2, SHADOW_SIZE2, SHADOW_SIZE2), FlatUIUtils.getUIFloat((String)"Popup.dropShadowOpacity", (float)0.5f)) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                FlatUIUtils.setRenderingHints((Graphics)g2);
                g2.translate(x, y);
                int sx = 0;
                int sy = 0;
                int sw = width;
                int sh = height;
                int arrowSize = UIScale.scale((int)ARROW_SIZE);
                switch (this.direction) {
                    case 2: {
                        sx += arrowSize;
                        sw -= arrowSize;
                        break;
                    }
                    case 1: {
                        sy += arrowSize;
                        sh -= arrowSize;
                        break;
                    }
                    case 4: {
                        sw -= arrowSize;
                        break;
                    }
                    case 3: {
                        sh -= arrowSize;
                    }
                }
                if (this.shadowBorder != null) {
                    this.shadowBorder.paintBorder(c, g2, sx, sy, sw, sh);
                }
                int bx = UIScale.scale((int)SHADOW_SIZE);
                int by = UIScale.scale((int)SHADOW_TOP_SIZE);
                int bw = width - UIScale.scale((int)(SHADOW_SIZE + SHADOW_SIZE));
                int bh = height - UIScale.scale((int)(SHADOW_TOP_SIZE + SHADOW_SIZE));
                g2.translate(bx, by);
                Shape shape = this.createBalloonShape(bw, bh);
                g2.setColor(c.getBackground());
                g2.fill(shape);
                g2.setColor(this.borderColor);
                g2.setStroke(new BasicStroke(UIScale.scale((float)1.0f)));
                g2.draw(shape);
            }
            finally {
                g2.dispose();
            }
        }

        private Shape createBalloonShape(int width, int height) {
            Path2D arrow;
            RoundRectangle2D.Float rect;
            int arc = UIScale.scale((int)ARC);
            int xy = UIScale.scale((int)ARROW_XY);
            int awh = UIScale.scale((int)ARROW_SIZE);
            switch (this.direction) {
                case 2: {
                    rect = new RoundRectangle2D.Float(awh, 0.0f, width - 1 - awh, height - 1, arc, arc);
                    arrow = FlatUIUtils.createPath((double[])new double[]{awh, xy, 0.0, xy + awh, awh, xy + awh + awh});
                    break;
                }
                case 1: {
                    rect = new RoundRectangle2D.Float(0.0f, awh, width - 1, height - 1 - awh, arc, arc);
                    arrow = FlatUIUtils.createPath((double[])new double[]{xy, awh, xy + awh, 0.0, xy + awh + awh, awh});
                    break;
                }
                case 4: {
                    rect = new RoundRectangle2D.Float(0.0f, 0.0f, width - 1 - awh, height - 1, arc, arc);
                    int x = width - 1 - awh;
                    arrow = FlatUIUtils.createPath((double[])new double[]{x, xy, x + awh, xy + awh, x, xy + awh + awh});
                    break;
                }
                case 3: {
                    rect = new RoundRectangle2D.Float(0.0f, 0.0f, width - 1, height - 1 - awh, arc, arc);
                    int y = height - 1 - awh;
                    arrow = FlatUIUtils.createPath((double[])new double[]{xy, y, xy + awh, y + awh, xy + awh + awh, y});
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            Area area = new Area(rect);
            area.add(new Area(arrow));
            return area;
        }
    }
}

