/*
 * Decompiled with CFR 0.152.
 */
package sandbox;

import com.towel.collections.paginator.ListPaginator;
import com.towel.collections.paginator.Paginator;
import com.towel.swing.table.ObjectTableModel;
import java.util.List;
import javax.swing.JTable;
import sandbox.NewSelectTable;

public class AdvancedJTableBuilder<T> {
    private ObjectTableModel<T> model;
    private Paginator<T> paginator;
    private JTable table;

    public AdvancedJTableBuilder<T> buildWithModel(ObjectTableModel<T> model) {
        this.model = model;
        return this;
    }

    public AdvancedJTableBuilder<T> buildFor(JTable table) {
        this.table = table;
        this.model = (ObjectTableModel)table.getModel();
        return this;
    }

    public AdvancedJTableBuilder<T> withData(List<T> list) {
        return this.withData(list, 30);
    }

    public AdvancedJTableBuilder<T> withData(List<T> list, int resultsPerPage) {
        this.checkNull(this.model, "You should call some method to create a TableModel!");
        this.paginator = new ListPaginator<T>(list, resultsPerPage);
        return this;
    }

    public AdvancedJTableBuilder<T> withData(Paginator<T> paginator) {
        this.checkNull(this.model, "You should call some method to create a TableModel!");
        this.paginator = paginator;
        return this;
    }

    public NewSelectTable<T> create() {
        this.checkNull(this.model, "You should call some method to create a TableModel!");
        this.checkNull(this.paginator, "You should call some method to create a Paginator!");
        return new NewSelectTable<T>(this.model, this.paginator);
    }

    private void checkNull(Object any, String illegalStateMessage) {
        if (any == null) {
            throw new IllegalStateException(illegalStateMessage);
        }
    }
}

