/*
 * Decompiled with CFR 0.152.
 */
package sandbox;

import java.awt.Point;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import sandbox.Selectable;

public class JKSSelect
extends JComponent {
    private Point point;
    private JComponent component;
    private Vector<Selectable> unselected;
    private Vector<Selectable> selected;

    public JKSSelect(JComponent component, Vector<? extends Selectable> selection) {
        this.component = component;
        this.unselected = selection;
        this.selected = new Vector();
        this.containerAction(component);
        this.point = new Point();
        super.setBorder(BorderFactory.createTitledBorder(""));
        component.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof Selectable) {
                    e.getChild().addMouseListener(new JKSClick());
                }
            }
        });
    }

    private void makeSquare(Point a, Point b) {
        if (a == null || b == null) {
            a = new Point(0, 0);
            b = new Point(0, 0);
        }
        if (a.x == 0 && a.y == 0 && b.x == 0 && b.y == 0) {
            this.setLocation(0, 0);
            this.setSize(0, 0);
        }
        if (a.x >= b.x && a.y > b.y || a.x < b.x && a.y >= b.y) {
            Point aux = a;
            a = b;
            b = aux;
        }
        if (a.x <= b.x && a.y < b.y) {
            this.setLocation(a.x, a.y);
            this.setSize(b.x - a.x, b.y - a.y);
        } else if (a.x > b.x && a.y <= b.y) {
            this.setLocation(b.x, a.y);
            this.setSize(a.x - b.x, b.y - a.y);
        }
    }

    public void containerAction(JComponent container) {
        container.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                JKSSelect.this.unselectAll();
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                if (!arg0.isControlDown()) {
                    JKSSelect.this.unselectAll();
                }
                JKSSelect.this.point = arg0.getPoint();
                JKSSelect.this.setVisible(true);
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                JKSSelect.this.setVisible(false);
                for (int x = 0; x < JKSSelect.this.unselected.size(); ++x) {
                    if (!new Rectangle2D.Double(JKSSelect.this.getLocation().getX(), JKSSelect.this.getLocation().getY(), JKSSelect.this.getSize().getWidth(), JKSSelect.this.getSize().getHeight()).contains(((Selectable)JKSSelect.this.unselected.get(x)).getLocation())) continue;
                    ((Selectable)JKSSelect.this.unselected.get(x)).setSelected(true);
                    JKSSelect.this.selected.add((Selectable)JKSSelect.this.unselected.remove(x));
                    --x;
                }
                JKSSelect.this.makeSquare(new Point(0, 0), new Point(0, 0));
            }
        });
        container.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent arg0) {
                JKSSelect.this.makeSquare(JKSSelect.this.point, arg0.getPoint());
            }
        });
    }

    public void unselectAll() {
        while (this.selected.size() != 0) {
            this.selected.get(0).setSelected(false);
            this.unselected.add(this.selected.remove(0));
        }
    }

    public void selectAll() {
        while (this.unselected.size() != 0) {
            this.unselected.get(0).setSelected(true);
            this.selected.add(this.unselected.remove(0));
        }
    }

    public Vector<? extends Selectable> getSelectedArray() {
        return this.selected;
    }

    public Vector<? extends Selectable> getUnselectedArray() {
        return this.unselected;
    }

    class JKSClick
    extends MouseAdapter {
        JKSClick() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            System.out.printf("Clicado", new Object[0]);
            if (!e.isControlDown()) {
                JKSSelect.this.unselectAll();
            }
            if (JKSSelect.this.selected.remove((Selectable)((Object)e.getComponent()))) {
                JKSSelect.this.unselected.add((Selectable)((Object)e.getComponent()));
                ((Selectable)((Object)e.getComponent())).setSelected(false);
            } else if (JKSSelect.this.unselected.remove((Selectable)((Object)e.getComponent()))) {
                JKSSelect.this.selected.add((Selectable)((Object)e.getComponent()));
                ((Selectable)((Object)e.getComponent())).setSelected(true);
            }
        }
    }
}

