/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.inject.assistedinject.Assisted;
import com.seleritycorp.common.base.cache.CacheMetricsMBean;
import com.seleritycorp.common.base.time.Clock;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.inject.Inject;

public class CacheMetrics
implements CacheMetricsMBean {
    private final Clock clock;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Initial checks are unsynchronized. But if they fail, they are repeated synchronized")
    private long nextStatsUpdateMillis = 0L;
    private long statsCacheIntervalMillis = 10000L;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Sync is only needed forsetting it.")
    private CacheStats stats;
    private final Cache<? extends Object, ? extends Object> cache;

    @Inject
    CacheMetrics(@Assisted Cache<? extends Object, ? extends Object> cache, Clock clock) {
        this.cache = cache;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheStats getStats() {
        long nowMillis = this.clock.getMillisEpoch();
        if (this.nextStatsUpdateMillis < nowMillis) {
            CacheMetrics cacheMetrics = this;
            synchronized (cacheMetrics) {
                if (this.nextStatsUpdateMillis < nowMillis) {
                    this.stats = this.cache.stats();
                    this.nextStatsUpdateMillis = nowMillis + this.statsCacheIntervalMillis;
                }
            }
        }
        return this.stats;
    }

    @Override
    public long getHitCount() {
        return this.getStats().hitCount();
    }

    @Override
    public long getMissCount() {
        return this.getStats().missCount();
    }

    @Override
    public long getLoadSuccessCount() {
        return this.getStats().loadSuccessCount();
    }

    @Override
    public long getLoadExceptionCount() {
        return this.getStats().loadExceptionCount();
    }

    @Override
    public long getTotalLoadTimeNanos() {
        return this.getStats().totalLoadTime();
    }

    @Override
    public long getEvictionCount() {
        return this.getStats().evictionCount();
    }

    @Override
    public long getSize() {
        return this.cache.size();
    }

    static interface Factory {
        public CacheMetrics create(Cache<? extends Object, ? extends Object> var1);
    }
}

