/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.cache;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.inject.assistedinject.Assisted;
import com.seleritycorp.common.base.cache.CacheMetrics;
import com.seleritycorp.common.base.jmx.MBeanUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;

public class MonitoredCacheBuilder<K, V> {
    private static AtomicInteger builtCount = new AtomicInteger();
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Synchronization is only needed for setting")
    private String name;
    private CacheBuilder<? super K, ? super V> builder;
    private final CacheMetrics.Factory cacheMetricsFactory;

    @Inject
    MonitoredCacheBuilder(@Assisted String name, Ticker ticker, CacheMetrics.Factory cacheMetricsFactory) {
        this.name = name;
        this.cacheMetricsFactory = cacheMetricsFactory;
        this.builder = CacheBuilder.newBuilder();
        this.builder.ticker(ticker);
        this.builder.recordStats();
    }

    private MonitoredCacheBuilder(String name, CacheBuilder<K, V> builder, CacheMetrics.Factory cacheMetricsFactory) {
        this.name = name;
        this.builder = builder;
        this.cacheMetricsFactory = cacheMetricsFactory;
    }

    public MonitoredCacheBuilder<K, V> concurrencyLevel(int concurrencyLevel) {
        this.builder = this.builder.concurrencyLevel(concurrencyLevel);
        return this;
    }

    public MonitoredCacheBuilder<K, V> expireAfterAccess(long duration, TimeUnit unit) {
        this.builder = this.builder.expireAfterAccess(duration, unit);
        return this;
    }

    public MonitoredCacheBuilder<K, V> expireAfterWrite(long duration, TimeUnit unit) {
        this.builder = this.builder.expireAfterWrite(duration, unit);
        return this;
    }

    public MonitoredCacheBuilder<K, V> initialCapacity(int initialCapacity) {
        this.builder = this.builder.initialCapacity(initialCapacity);
        return this;
    }

    public MonitoredCacheBuilder<K, V> maximumSize(long size) {
        this.builder = this.builder.maximumSize(size);
        return this;
    }

    public MonitoredCacheBuilder<K, V> refreshAfterWrite(long duration, TimeUnit unit) {
        this.builder = this.builder.refreshAfterWrite(duration, unit);
        return this;
    }

    public <K1 extends K, V1 extends V> MonitoredCacheBuilder<K1, V1> removalListener(RemovalListener<? super K1, ? super V1> listener) {
        return new MonitoredCacheBuilder<K, V>(this.name, this.builder.removalListener(listener), this.cacheMetricsFactory);
    }

    public synchronized MonitoredCacheBuilder<K, V> name(String name) {
        this.name = name;
        return this;
    }

    public <K1 extends K, V1 extends V> LoadingCache<K1, V1> build(CacheLoader<? super K1, V1> loader) {
        LoadingCache ret = this.builder.build(loader);
        this.postBuildSteps((Cache<K1, V1>)ret);
        return ret;
    }

    public <K1 extends K, V1 extends V> Cache<K1, V1> build() {
        Cache ret = this.builder.build();
        this.postBuildSteps(ret);
        return ret;
    }

    private synchronized <K1 extends K, V1 extends V> void postBuildSteps(Cache<K1, V1> cache) {
        int count = builtCount.incrementAndGet();
        if (this.name == null) {
            this.name = "unnamed-" + count;
        }
        if (this.cacheMetricsFactory != null) {
            CacheMetrics cacheMetrics = this.cacheMetricsFactory.create(cache);
            String jmxName = "com.seleritycorp.common.base.cache:type=MonitoredCache,name=" + this.name;
            MBeanUtils.register(jmxName, cacheMetrics);
        }
        this.name = null;
    }

    public static interface Factory {
        public MonitoredCacheBuilder<Object, Object> create(String var1);
    }
}

