/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.cache.callable;

import java.util.concurrent.Callable;

public class StaticTrackingCallable<T>
implements Callable<T> {
    private final T callResult;
    boolean uncalled;

    public StaticTrackingCallable(T callResult) {
        this.callResult = callResult;
        this.reset();
    }

    public void reset() {
        this.uncalled = true;
    }

    @Override
    public T call() {
        this.uncalled = false;
        return this.callResult;
    }

    public boolean isUncalled() {
        return this.uncalled;
    }

    public static class Factory {
        public <T> StaticTrackingCallable<T> create(T callResult) {
            return new StaticTrackingCallable<T>(callResult);
        }
    }
}

