/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.config;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.seleritycorp.common.base.config.ApplicationConfig;
import com.seleritycorp.common.base.config.ApplicationConfigProvider;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.config.ConfigFile;
import com.seleritycorp.common.base.config.EnvironmentConfig;
import com.seleritycorp.common.base.config.EnvironmentConfigProvider;
import com.seleritycorp.common.base.config.SingleFileConfig;
import com.seleritycorp.common.base.inject.InjectorFactory;
import java.nio.file.Path;
import javax.inject.Singleton;

public class ConfigModule
extends AbstractModule {
    protected void configure() {
        this.bind(Config.class).annotatedWith(EnvironmentConfig.class).toProvider(EnvironmentConfigProvider.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @ApplicationConfig
    Config provideApplicationConfig() {
        Injector injector = InjectorFactory.getInjector();
        if (injector.getExistingBinding(Key.get(Path.class, ConfigFile.class)) == null) {
            return ((ApplicationConfigProvider)injector.getInstance(ApplicationConfigProvider.class)).get();
        }
        return (Config)injector.getInstance(SingleFileConfig.class);
    }
}

