/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.coreservices;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.seleritycorp.common.base.config.ApplicationConfig;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.config.ConfigUtils;
import com.seleritycorp.common.base.coreservices.CallErrorException;
import com.seleritycorp.common.base.coreservices.RawCoreServiceClient;
import com.seleritycorp.common.base.http.client.HttpException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AuthenticationClient {
    private RawCoreServiceClient client;
    private final String user;
    private final String password;

    @Inject
    public AuthenticationClient(@ApplicationConfig Config appConfig, RawCoreServiceClient client) {
        this.client = client;
        Config config = ConfigUtils.subconfig(appConfig, "CoreServices");
        this.user = config.get("user");
        this.password = config.get("password");
    }

    public String getAuthThoken() throws HttpException, CallErrorException {
        String token;
        JsonObject params = new JsonObject();
        params.addProperty("user", this.user);
        params.addProperty("password", this.password);
        String method = "AuthenticationHandler.authenticate";
        JsonElement result = this.client.call("AuthenticationHandler.authenticate", (JsonElement)params, null, 10000);
        try {
            token = result.getAsJsonObject().get("id").getAsString();
        }
        catch (NullPointerException e) {
            throw new CallErrorException("Failed to extract token id from response", e);
        }
        return token;
    }
}

