/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.coreservices;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.seleritycorp.common.base.config.ApplicationConfig;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.config.ConfigUtils;
import com.seleritycorp.common.base.coreservices.AuthenticationClient;
import com.seleritycorp.common.base.coreservices.CallErrorException;
import com.seleritycorp.common.base.coreservices.RawCoreServiceClient;
import com.seleritycorp.common.base.http.client.HttpException;
import com.seleritycorp.common.base.time.Clock;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RawAuthenticatedCoreServiceClient {
    private final RawCoreServiceClient client;
    private final AuthenticationClient authenticationClient;
    private final Clock clock;
    private final long tokenTimeoutPeriodSeconds;
    private String token;
    private long tokenTimeoutTimestamp;

    @Inject
    public RawAuthenticatedCoreServiceClient(@ApplicationConfig Config appConfig, RawCoreServiceClient client, AuthenticationClient authenticationClient, Clock clock) {
        this.client = client;
        this.authenticationClient = authenticationClient;
        this.clock = clock;
        Config config = ConfigUtils.subconfig(appConfig, "CoreServices");
        this.tokenTimeoutPeriodSeconds = config.getDurationSeconds("tokenTimeout", 180L);
        this.token = null;
        this.tokenTimeoutTimestamp = 0L;
    }

    public JsonElement authenticatedCall(String method, JsonElement params) throws HttpException, CallErrorException {
        return this.authenticatedCall(method, params, -1);
    }

    public JsonElement authenticatedCall(String method, JsonElement params, int timeoutMillis) throws HttpException, CallErrorException {
        JsonElement ret;
        if (this.token == null || this.tokenTimeoutTimestamp < this.clock.getSecondsEpoch()) {
            this.token = null;
            this.token = this.authenticationClient.getAuthThoken();
            this.tokenTimeoutTimestamp = this.clock.getSecondsEpoch() + this.tokenTimeoutPeriodSeconds;
        }
        try {
            ret = this.client.call(method, params, this.token, timeoutMillis);
        }
        catch (Exception e) {
            this.token = null;
            throw e;
        }
        return ret;
    }

    public void authenticatedCall(String method, JsonElement params, int timeoutMillis, JsonWriter writer) throws HttpException, CallErrorException {
        if (this.token == null || this.tokenTimeoutTimestamp < this.clock.getSecondsEpoch()) {
            this.token = null;
            this.token = this.authenticationClient.getAuthThoken();
            this.tokenTimeoutTimestamp = this.clock.getSecondsEpoch() + this.tokenTimeoutPeriodSeconds;
        }
        try {
            this.client.call(method, params, this.token, timeoutMillis, writer);
        }
        catch (Exception e) {
            this.token = null;
            throw e;
        }
    }
}

