/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.common;

public class HeaderParameter
implements Comparable<HeaderParameter> {
    private final String key;
    private final String value;

    public HeaderParameter(String key, String value) {
        this.key = key != null ? key.toLowerCase() : "";
        this.value = value != null ? value : "";
    }

    public HeaderParameter(String raw) {
        String[] parts = raw.split("=");
        this.key = parts[0].trim().toLowerCase();
        this.value = parts.length > 1 ? parts[1].trim() : "";
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeaderParameter other = (HeaderParameter)obj;
        if (!this.key.equals(other.key)) {
            return false;
        }
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    @Override
    public int compareTo(HeaderParameter other) {
        int ret = this.key.compareTo(other.key);
        if (ret == 0) {
            ret = this.value.compareTo(other.value);
        }
        return ret;
    }
}

