/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.server;

import com.seleritycorp.common.base.http.server.HttpRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public abstract class AbstractHttpHandler
extends AbstractHandler {
    private HttpRequest.Factory httpRequestFactory;

    @Inject
    void setHttpRequestFactory(HttpRequest.Factory httpRequestFactory) {
        this.httpRequestFactory = httpRequestFactory;
    }

    public abstract void handle(HttpRequest var1) throws IOException, ServletException;

    public void handle(String target, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        block6: {
            try {
                HttpRequest httpRequest = null;
                try {
                    httpServletResponse.setHeader("Server", "n/a");
                    httpRequest = this.httpRequestFactory.create(target, request, httpServletRequest, httpServletResponse);
                    this.handle(httpRequest);
                    if (!httpRequest.hasBeenHandled()) {
                        httpRequest.respondNotFound();
                    }
                }
                catch (Exception exception) {
                    if (httpRequest != null) {
                        httpRequest.respondInternalServerError("Uncaught " + exception.toString() + " in " + ((Object)((Object)this)).getClass(), exception);
                        break block6;
                    }
                    throw exception;
                }
            }
            catch (Exception exception) {
                this.lastResortCleanup(request, httpServletResponse);
            }
        }
    }

    private void lastResortCleanup(Request request, HttpServletResponse httpServletResponse) {
        String msg = "Internal server error.";
        try {
            httpServletResponse.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            httpServletResponse.setStatus(500);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            httpServletResponse.setHeader("Server", "n/a");
        }
        catch (Exception exception) {
            // empty catch block
        }
        PrintWriter writer = null;
        try {
            writer = httpServletResponse.getWriter();
            writer.println(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServletOutputStream stream = null;
        try {
            stream = httpServletResponse.getOutputStream();
            stream.write(msg.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (!request.isHandled()) {
                request.setHandled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

