/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.server;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.seleritycorp.common.base.http.server.AbstractHttpHandler;
import com.seleritycorp.common.base.http.server.BasicErrorCode;
import com.seleritycorp.common.base.http.server.HttpRequest;
import com.seleritycorp.common.base.state.AppStateManager;
import java.io.IOException;
import javax.servlet.ServletException;

public class CommonHttpHandler
extends AbstractHttpHandler {
    private final AbstractHttpHandler delegateHttpHandler;
    private final AppStateManager appStateManager;

    @Inject
    CommonHttpHandler(@Assisted AbstractHttpHandler delegateHttpHandler, AppStateManager appStateManager) {
        this.delegateHttpHandler = delegateHttpHandler;
        this.appStateManager = appStateManager;
    }

    @Override
    public void handle(HttpRequest request) throws IOException, ServletException {
        switch (request.getTarget()) {
            case "/status": {
                if (request.isMethodGet()) {
                    String sender = request.getResolvedRemoteAddr();
                    if (sender.startsWith("10.") || sender.startsWith("127.")) {
                        request.respondOkText(this.appStateManager.getStatusReport());
                        break;
                    }
                    request.respondForbidden();
                    break;
                }
                request.respondBadRequest(BasicErrorCode.E_WRONG_METHOD, "Target " + request.getTarget() + " expects GET method");
                break;
            }
            default: {
                this.delegateHttpHandler.handle(request);
            }
        }
        if (!request.hasBeenHandled()) {
            request.respondNotFound();
        }
    }

    static interface Factory {
        public CommonHttpHandler create(AbstractHttpHandler var1);
    }
}

