/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.server;

public class ForwardedForResolver {
    boolean isIp(String ip) {
        String[] octets;
        boolean ret = false;
        if (ip != null && !ip.isEmpty() && (octets = ip.split("\\.")).length == 4) {
            ret = true;
            for (int idx = 0; idx < 4 && ret; ++idx) {
                try {
                    int octet = Integer.parseInt(octets[idx]);
                    ret &= octet >= 0 && octet <= 255;
                    continue;
                }
                catch (Exception e) {
                    ret = false;
                }
            }
        }
        return ret;
    }

    boolean isTrustedIp(String ip) {
        boolean ret = false;
        ret |= ip.startsWith("10.");
        ret |= ip.startsWith("127.");
        return ret |= ip.startsWith("192.168.");
    }

    public String resolve(String remoteAddr, String forwardedFor) {
        String ret = remoteAddr;
        if (forwardedFor != null && !forwardedFor.isEmpty() && this.isTrustedIp(remoteAddr)) {
            String[] headerIps = forwardedFor.split(",");
            boolean continueSearch = true;
            for (int idx = headerIps.length - 1; idx >= 0 && continueSearch; --idx) {
                String ip = headerIps[idx].trim();
                if (this.isIp(ip)) {
                    ret = ip;
                    if (this.isTrustedIp(ip)) continue;
                    continueSearch = false;
                    continue;
                }
                continueSearch = false;
            }
        }
        return ret;
    }
}

