/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.server;

import com.google.gson.JsonObject;
import com.google.inject.assistedinject.Assisted;
import com.seleritycorp.common.base.config.ApplicationConfig;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.escape.Escaper;
import com.seleritycorp.common.base.http.common.ContentType;
import com.seleritycorp.common.base.http.server.BasicErrorCode;
import com.seleritycorp.common.base.http.server.ContentTypeNegotiator;
import com.seleritycorp.common.base.http.server.ErrorCode;
import com.seleritycorp.common.base.http.server.ForwardedForResolver;
import com.seleritycorp.common.base.logging.Level;
import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import com.seleritycorp.common.base.time.TimeUtils;
import com.seleritycorp.common.base.uuid.UuidGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.server.Request;

public class HttpRequest {
    private static final Log log = LogFactory.getLog(HttpRequest.class);
    private final String target;
    private final Request request;
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private final ForwardedForResolver forwardedForResolver;
    private final ContentTypeNegotiator contentTypeNegotiator;
    private final UuidGenerator uuidGenerator;
    private final Escaper escaper;
    private final TimeUtils timeUtils;
    private final String serverId;
    private final String supportEmailAddress;

    @Inject
    public HttpRequest(@Assisted String target, @Assisted Request request, @Assisted HttpServletRequest httpServletRequest, @Assisted HttpServletResponse httpServletResponse, ForwardedForResolver forwardedForResolver, ContentTypeNegotiator contentTypeNegotiator, UuidGenerator uuidGenerator, Escaper escaper, TimeUtils timeUtils, @ApplicationConfig Config config) {
        this.target = target;
        this.request = request;
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
        this.forwardedForResolver = forwardedForResolver;
        this.contentTypeNegotiator = contentTypeNegotiator;
        this.uuidGenerator = uuidGenerator;
        this.escaper = escaper;
        this.timeUtils = timeUtils;
        this.serverId = config.get("server.id", "n/a");
        this.supportEmailAddress = config.get("server.support.email", "support@selerityinc.com");
    }

    public String getTarget() {
        return this.target;
    }

    public String getRequestBodyAsString() throws IOException {
        try (BufferedReader reader = this.httpServletRequest.getReader();){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
    }

    public boolean isMethodGet() {
        return "GET".equals(this.httpServletRequest.getMethod());
    }

    public boolean isMethodPost() {
        return "POST".equals(this.httpServletRequest.getMethod());
    }

    public boolean hasBeenHandled() {
        return this.request.isHandled();
    }

    public String getResolvedRemoteAddr() {
        String remoteAddr = this.httpServletRequest.getRemoteAddr();
        String forwardedFor = this.httpServletRequest.getHeader("X-Forwarded-For");
        return this.forwardedForResolver.resolve(remoteAddr, forwardedFor);
    }

    public ContentType getMostSuitableResponseContentType(ContentType fallback, ContentType ... candidates) {
        String acceptHeader = this.httpServletRequest.getHeader("Accept");
        ContentType negotiated = this.contentTypeNegotiator.negotiate(acceptHeader, fallback, candidates);
        return negotiated;
    }

    private void respond(int status, ContentType contentType, String response) throws IOException {
        this.httpServletResponse.setStatus(status);
        this.httpServletResponse.setHeader("Server", this.serverId);
        if (response != null) {
            if (contentType != null) {
                this.httpServletResponse.setContentType(contentType.toString());
            }
            try (PrintWriter writer = this.httpServletResponse.getWriter();){
                writer.print(response);
            }
        }
        this.setHandled();
    }

    private UUID logRequest(int status, ErrorCode errorCode, String clientExplanation) {
        UUID incidentId = this.uuidGenerator.generate();
        log.structuredInfo("http-server-incident", 2, "incidentId", incidentId, "remoteAddress", this.httpServletRequest.getRemoteAddr(), "resolvedRemoteAddress", this.getResolvedRemoteAddr(), "method", this.httpServletRequest.getMethod(), "target", this.getTarget(), "status", status, "errorCode", errorCode != null ? errorCode.getIdentifier() : null, "clientExplanation", clientExplanation, "devExplanation", null, "throwable", null);
        return incidentId;
    }

    private UUID respondGenericIssue(int status, ErrorCode errorCode, String clientExplanation) throws IOException {
        return this.respondGenericIssue(status, errorCode, clientExplanation, Level.OFF, null, null);
    }

    private UUID respondGenericIssue(int status, ErrorCode errorCode, String clientExplanation, Level logLevel, String logMessage, Throwable logException) throws IOException {
        UUID incidentId = this.logRequest(status, errorCode, clientExplanation);
        if (logLevel != Level.OFF) {
            logMessage = "(IncidentId: " + incidentId.toString() + ") " + logMessage;
            if (logException == null) {
                log.log(logLevel, logMessage);
            } else {
                log.log(logLevel, logMessage, logException);
            }
        }
        ContentType responseContentType = this.getMostSuitableResponseContentType(ContentType.TEXT_PLAIN, ContentType.TEXT_HTML, ContentType.APPLICATION_JSON);
        String errorCodeIdentifier = errorCode != null ? errorCode.getIdentifier() : null;
        String msg = "";
        if (ContentType.TEXT_PLAIN.equals(responseContentType)) {
            msg = msg + "An error occurred for your request to " + this.getTarget() + "\n";
            msg = msg + "\n";
            msg = msg + clientExplanation + "\n";
            msg = msg + "\n";
            msg = msg + "Error code: " + errorCodeIdentifier + "\n";
            msg = msg + "Explanation: " + clientExplanation + "\n";
            msg = msg + "Incident id: " + incidentId + "\n";
            msg = msg + "Server id: " + this.serverId + "\n";
            msg = msg + "Server timestamp: " + this.timeUtils.formatTimeNanos() + "\n";
            msg = msg + "\n";
            msg = msg + "If the above is unexpected or you have questions, please let us know at " + this.supportEmailAddress + " and attach the above data.\n";
        } else if (ContentType.TEXT_HTML.equals(responseContentType)) {
            msg = msg + "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n";
            msg = msg + "  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n";
            msg = msg + "<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n";
            msg = msg + "  <head>\n";
            msg = msg + "    <title>Error while accessing " + this.escaper.html(this.getTarget()) + "</title>\n";
            msg = msg + "    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />\n";
            msg = msg + "    <style type=\"text/css\">\n";
            msg = msg + "      table, tr, th, td {\n";
            msg = msg + "        border: 1px solid black;\n";
            msg = msg + "      }\n";
            msg = msg + "      th, td {\n";
            msg = msg + "        padding: 0.2em 0.5em 0.2em 0.5em;\n";
            msg = msg + "      }\n";
            msg = msg + "      table {\n";
            msg = msg + "        border-collapse: collapse;\n";
            msg = msg + "      }\n";
            msg = msg + "      th {\n";
            msg = msg + "        text-align: left;\n";
            msg = msg + "      }\n";
            msg = msg + "    </style>\n";
            msg = msg + "  </head>\n";
            msg = msg + "  <body>\n";
            msg = msg + "    <p>An error occurred for your request to " + this.escaper.html(this.getTarget()) + "</p>\n";
            msg = msg + "    <p>" + this.escaper.html(clientExplanation) + "</p>\n";
            msg = msg + "    <table>\n";
            msg = msg + "      <tr><th>Error code</th><td>" + this.escaper.html(errorCodeIdentifier) + "</td></tr>\n";
            msg = msg + "      <tr><th style=\"text-align:left;\">Explanation</th><td>" + this.escaper.html(clientExplanation) + "</td></tr>\n";
            msg = msg + "      <tr><th style=\"text-align:left;\">Incident id</th><td>" + this.escaper.html(incidentId.toString()) + "</td></tr>\n";
            msg = msg + "      <tr><th style=\"text-align:left;\">Server id</th><td>" + this.escaper.html(this.serverId) + "</td></tr>\n";
            msg = msg + "      <tr><th style=\"text-align:left;\">Server time</th><td>" + this.timeUtils.formatTimeNanos() + "</td></tr>\n";
            msg = msg + "    </table>\n";
            msg = msg + "    <p>If the above is unexpected or you have questions, please let us know at <a href=\"" + this.escaper.html(this.supportEmailAddress) + "\">" + this.escaper.html(this.supportEmailAddress) + "</a> and attach the above data.</p>\n";
            msg = msg + "  </body>\n";
            msg = msg + "</html>\n";
        } else if (ContentType.APPLICATION_JSON.equals(responseContentType)) {
            JsonObject object = new JsonObject();
            object.addProperty("errorCode", errorCodeIdentifier);
            object.addProperty("explanation", clientExplanation);
            object.addProperty("target", this.getTarget());
            object.addProperty("incidentId", incidentId.toString());
            object.addProperty("serverId", this.serverId);
            object.addProperty("serverTimestamp", this.timeUtils.formatTimeNanos());
            object.addProperty("support", "If the above is unexpected or you have questions, please let us know at " + this.supportEmailAddress + " and attach this JSON blob.");
            msg = object.toString();
        } else {
            msg = "Unkonwn ContentType " + responseContentType;
        }
        this.respond(status, responseContentType, msg);
        return incidentId;
    }

    public void respondOkText(String response) throws IOException {
        this.respond(200, ContentType.TEXT_PLAIN, response);
    }

    public void respondNoContent() throws IOException {
        this.respond(204, null, null);
    }

    public UUID respondBadRequest(ErrorCode errorCode, String clientExplanation) throws IOException {
        if (clientExplanation == null) {
            clientExplanation = errorCode.getDefaultReason();
        }
        int status = 400;
        return this.respondGenericIssue(400, errorCode, clientExplanation);
    }

    public UUID respondBadRequest(ErrorCode errorCode) throws IOException {
        return this.respondBadRequest(errorCode, null);
    }

    public UUID respondForbidden() throws IOException {
        BasicErrorCode errorCode = BasicErrorCode.E_FORBIDDEN;
        String clientExplanation = errorCode.getDefaultReason();
        int status = 403;
        return this.respondGenericIssue(403, errorCode, clientExplanation);
    }

    public UUID respondNotFound() throws IOException {
        BasicErrorCode errorCode = BasicErrorCode.E_NOT_FOUND;
        String clientExplanation = errorCode.getDefaultReason();
        int status = 404;
        return this.respondGenericIssue(404, errorCode, clientExplanation);
    }

    public UUID respondInternalServerError(String logMessage, Throwable logException) throws IOException {
        BasicErrorCode errorCode = BasicErrorCode.E_INTERNAL_SERVER_ERROR;
        String clientExplanation = errorCode.getDefaultReason();
        int status = 500;
        return this.respondGenericIssue(500, errorCode, clientExplanation, Level.ERROR, logMessage, logException);
    }

    public void setHandled() {
        this.request.setHandled(true);
    }

    public static interface Factory {
        public HttpRequest create(String var1, Request var2, HttpServletRequest var3, HttpServletResponse var4);
    }
}

