/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.http.server;

import com.seleritycorp.common.base.config.ApplicationConfig;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.http.server.AbstractHttpHandler;
import com.seleritycorp.common.base.http.server.BaseHttpHandler;
import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import com.seleritycorp.common.base.state.AppState;
import com.seleritycorp.common.base.state.AppStateFacetFactory;
import com.seleritycorp.common.base.state.AppStatePushFacet;
import com.seleritycorp.common.base.thread.ExecutorServiceFactory;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class HttpServer
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(HttpServer.class);
    private Server server;
    private ServerConnector serverConnector;
    private AppStatePushFacet facet;
    private boolean isStarted;

    @Inject
    HttpServer(@ApplicationConfig Config config, @BaseHttpHandler AbstractHttpHandler httpHandler, ExecutorServiceFactory executorServiceFactory, AppStateFacetFactory appStateFacetFactory) {
        this.facet = appStateFacetFactory.createAppStatePushFacet("http-server");
        int threadCount = config.getInt("server.http.threads", 32);
        ExecutorService executorService = executorServiceFactory.createFixedUnboundedDaemonExecutorService("http-server", threadCount);
        ExecutorThreadPool executorThreadPool = new ExecutorThreadPool(executorService);
        this.server = new Server((ThreadPool)executorThreadPool);
        this.serverConnector = new ServerConnector(this.server);
        this.serverConnector.setReuseAddress(true);
        this.serverConnector.setPort(config.getInt("server.http.port", 8080));
        this.server.setConnectors(new Connector[]{this.serverConnector});
        this.server.setHandler((Handler)httpHandler);
        this.isStarted = false;
    }

    public void start() {
        this.facet.setAppState(AppState.INITIALIZING, "Starting");
        try {
            this.server.start();
            this.isStarted = true;
            this.facet.setAppState(AppState.READY, "Started");
        }
        catch (Exception e) {
            this.facet.setAppState(AppState.FAULTY, "Starting failed. " + e.getMessage());
            log.warn("Failed to start http server", e);
        }
    }

    @Override
    public void close() {
        this.facet.setAppState(AppState.FAULTY, "Stopped");
        this.serverConnector.close();
        try {
            this.server.stop();
            if (this.isStarted) {
                try {
                    this.server.join();
                }
                catch (InterruptedException e) {
                    this.facet.setAppState(AppState.FAULTY, "Joining failed. " + e.getMessage());
                    log.warn("Failed to join after stopping http server", e);
                }
            }
        }
        catch (Exception e) {
            this.facet.setAppState(AppState.FAULTY, "Stopping failed. " + e.getMessage());
            log.warn("Failed to stop http server", e);
        }
    }
}

