/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.inject;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.seleritycorp.common.base.cache.CacheModule;
import com.seleritycorp.common.base.config.ConfigModule;
import com.seleritycorp.common.base.config.ProductionModule;
import com.seleritycorp.common.base.http.client.HttpClientModule;
import com.seleritycorp.common.base.http.server.HttpServerModule;
import com.seleritycorp.common.base.logging.LoggingModule;
import com.seleritycorp.common.base.state.StateModule;
import com.seleritycorp.common.base.thread.ThreadModule;
import com.seleritycorp.common.base.time.TimeModule;
import com.seleritycorp.common.base.uuid.UuidModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InjectorFactory {
    private static Injector injector = null;
    private static List<AbstractModule> defaultModules = Arrays.asList(new AbstractModule[]{new ProductionModule(), new TimeModule(), new ConfigModule(), new LoggingModule(), new StateModule(), new UuidModule(), new HttpClientModule(), new HttpServerModule(), new ThreadModule(), new CacheModule()});
    private static List<AbstractModule> modules = new ArrayList<AbstractModule>(defaultModules);

    public static synchronized Injector getInjector() {
        if (injector == null) {
            injector = Guice.createInjector((Module[])new Module[0]);
            for (AbstractModule module : modules) {
                InjectorFactory.register(module);
            }
        }
        return injector;
    }

    public static synchronized void register(AbstractModule module) {
        if (injector == null) {
            modules.add(module);
        } else {
            injector = injector.createChildInjector(new Module[]{module});
        }
    }

    public static synchronized void forceInjector(Injector injector) {
        InjectorFactory.injector = injector;
        modules = injector == null ? new ArrayList<AbstractModule>(defaultModules) : new ArrayList<AbstractModule>();
    }
}

