/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.io;

import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class FileUtils {
    private static final Log log = LogFactory.getLog(FileUtils.class);

    public static void deleteFilesRecursivelySilentlyNoFollow(Path path) {
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            Files.delete(file);
                        }
                        catch (IOException e) {
                            log.warn("Failed to delete " + file, e);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (exc != null) {
                            log.warn("Failed deleting files for " + dir, exc);
                        }
                        try {
                            Files.delete(dir);
                        }
                        catch (IOException e) {
                            log.warn("Failed to delete " + dir, e);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                log.warn("Failed to delete " + path, e);
            }
        }
    }
}

