/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.logging;

import com.seleritycorp.common.base.inject.InjectorFactory;
import com.seleritycorp.common.base.logging.CommonsLog;
import com.seleritycorp.common.base.logging.FlatLog;
import com.seleritycorp.common.base.logging.Formatter;
import com.seleritycorp.common.base.logging.Log;
import org.apache.commons.logging.LogConfigurationException;

public class LogFactory {
    private static Formatter formatter = (Formatter)InjectorFactory.getInjector().getInstance(Formatter.class);

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return new CommonsLog(org.apache.commons.logging.LogFactory.getLog((String)name), formatter);
    }

    public static Log getPermanentLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getPermanentLog(clazz.getName());
    }

    public static Log getPermanentLog(String name) throws LogConfigurationException {
        return new FlatLog(LogFactory.getLog("permanent." + name), formatter);
    }
}

