/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.logging;

import com.seleritycorp.common.base.inject.InjectorFactory;
import com.seleritycorp.common.base.time.Clock;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.inject.Inject;
import org.apache.log4j.rolling.RollingPolicy;
import org.apache.log4j.rolling.RolloverDescription;
import org.apache.log4j.rolling.RolloverDescriptionImpl;
import org.apache.log4j.rolling.helper.Action;
import org.apache.log4j.rolling.helper.FileRenameAction;

public class RoverLikeRollingPolicy
implements RollingPolicy {
    private final Clock clock;
    private String rotateFormat;

    public RoverLikeRollingPolicy() {
        this((Clock)InjectorFactory.getInjector().getInstance(Clock.class));
    }

    @Inject
    public RoverLikeRollingPolicy(Clock clock) {
        this.clock = clock;
        this.setRotateFormat("application.%1$tFT%1$tT%2$s.log");
    }

    public void activateOptions() {
    }

    private long getTimestampForFile(Path path) {
        Long ret = null;
        try {
            ret = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ret == null) {
            ret = this.clock.getSecondsEpoch();
        }
        return ret;
    }

    private Action rotateFileAction(String src, Long timestamp) {
        FileRenameAction ret = null;
        File rotatedFile = null;
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(timestamp);
        for (int i = 1; rotatedFile == null || rotatedFile.exists() && i < 1024; ++i) {
            String suffix = i < 2 ? "" : "-" + i;
            String rotatedName = String.format(this.rotateFormat, cal, suffix);
            rotatedFile = new File(rotatedName);
        }
        if (!rotatedFile.exists()) {
            ret = new FileRenameAction(new File(src), rotatedFile, true);
        }
        return ret;
    }

    public RolloverDescription initialize(String file, boolean append) throws SecurityException {
        return this.rollover(file, append);
    }

    public RolloverDescription rollover(String activeFile) throws SecurityException {
        return this.rollover(activeFile, false);
    }

    public RolloverDescription rollover(String file, boolean append) throws SecurityException {
        if (file == null) {
            file = "application.log";
        }
        Path path = Paths.get(file, new String[0]);
        Action activeFileAction = null;
        try {
            if (Files.exists(path, new LinkOption[0]) && Files.size(path) > 0L && !append) {
                long timestamp = this.getTimestampForFile(path);
                activeFileAction = this.rotateFileAction(file, timestamp);
            }
        }
        catch (IOException e) {
            append = true;
        }
        Action archivingAction = null;
        return new RolloverDescriptionImpl(file, append, activeFileAction, archivingAction);
    }

    public String getRotateFormat() {
        return this.rotateFormat;
    }

    public void setRotateFormat(String rotateFormat) {
        this.rotateFormat = rotateFormat;
    }
}

