/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.logging;

import com.seleritycorp.common.base.inject.InjectorFactory;
import com.seleritycorp.common.base.time.Clock;
import javax.inject.Inject;
import org.apache.log4j.Appender;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.spi.LoggingEvent;

public class RoverLikeTriggeringPolicy
implements TriggeringPolicy {
    private final Clock clock;
    private int sizeLimit;
    private long timeLimitSeconds;
    private long nextBucketStartSeconds;

    public RoverLikeTriggeringPolicy() {
        this((Clock)InjectorFactory.getInjector().getInstance(Clock.class));
    }

    @Inject
    public RoverLikeTriggeringPolicy(Clock clock) {
        this.setSizeLimit(100000000);
        this.setTimeLimit(86400L);
        this.clock = clock;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public long getTimeLimit() {
        return this.timeLimitSeconds;
    }

    public void setTimeLimit(long timeLimit) {
        this.timeLimitSeconds = timeLimit;
    }

    private void updateNextBucketStart() {
        long seconds = this.clock.getSecondsEpoch();
        this.nextBucketStartSeconds = (seconds / this.timeLimitSeconds + 1L) * this.timeLimitSeconds;
    }

    public void activateOptions() {
        this.updateNextBucketStart();
    }

    public boolean isTriggeringEvent(Appender appender, LoggingEvent event, String filename, long fileLength) {
        boolean timeTriggered;
        boolean bl = timeTriggered = this.clock.getSecondsEpoch() >= this.nextBucketStartSeconds;
        if (timeTriggered) {
            this.updateNextBucketStart();
        }
        return timeTriggered || fileLength >= (long)this.sizeLimit;
    }
}

