/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.meta;

import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class BuildProperties {
    private static final Log log = LogFactory.getLog(BuildProperties.class);
    private final String resourceName;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Properties is thread safe. We use synchronization only to avoid loading it twice")
    private Properties properties;

    public BuildProperties(String groupId, String artifactId) {
        StringBuilder sb = new StringBuilder("/META-INF/");
        if (!"..".equals(groupId)) {
            sb.append("jar-info/");
            sb.append(groupId);
            sb.append('/');
        }
        sb.append(artifactId);
        sb.append("/build.properties");
        this.resourceName = sb.toString();
        this.properties = null;
    }

    private synchronized void loadProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            log.debug("Load properties from resource " + this.resourceName);
            try (InputStream stream = BuildProperties.class.getResourceAsStream(this.resourceName);){
                if (stream != null) {
                    this.properties.load(stream);
                } else {
                    log.error("Could not load '" + this.resourceName + "'");
                }
            }
            catch (IOException e) {
                log.error("Could not load '" + this.resourceName + "'", e);
            }
        }
    }

    public String getProperty(String key) {
        String ret = null;
        if (this.properties == null) {
            this.loadProperties();
        }
        if (this.properties != null) {
            ret = this.properties.getProperty(key);
        }
        return ret;
    }

    public String getGroupId() {
        return this.getProperty("groupId");
    }

    public String getArtifactId() {
        return this.getProperty("artifactId");
    }

    public String getVersion() {
        return this.getProperty("version");
    }

    public String getName() {
        return this.getProperty("name");
    }

    public String getGitBranch() {
        return this.getProperty("git.branch");
    }

    public String getGitHashAbbreviated() {
        return this.getProperty("git.hash.abbreviated");
    }

    public String getGitDescription() {
        return this.getProperty("git.description");
    }

    public String getBuildTime() {
        return this.getProperty("build.time");
    }
}

