/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.state;

import com.seleritycorp.common.base.config.ApplicationConfig;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.state.AppStateManager;
import com.seleritycorp.common.base.state.HaStateManager;
import com.seleritycorp.common.base.time.TimeUtils;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StateManagerPeriodicTasksRunner
implements Runnable {
    private final AppStateManager appStateManager;
    private final HaStateManager haStateManager;
    private Thread runner;
    private TimeUtils timeUtils;
    private final long pauseMillis;

    @Inject
    public StateManagerPeriodicTasksRunner(@ApplicationConfig Config config, AppStateManager appStateManager, HaStateManager haStateManager, TimeUtils timeUtils) {
        this.appStateManager = appStateManager;
        this.haStateManager = haStateManager;
        this.timeUtils = timeUtils;
        this.pauseMillis = config.getDurationMillis("StateManagerPeriodicTasksRunner.pause", 2000L);
        this.stop();
    }

    public void start() {
        Thread newRunner = new Thread(this);
        newRunner.setDaemon(true);
        this.runner = newRunner;
        newRunner.start();
    }

    public void stop() {
        this.runner = null;
    }

    @Override
    public void run() {
        InterruptedException exception = null;
        while (this.runner == Thread.currentThread() && exception == null) {
            this.appStateManager.readStatePaths();
            this.appStateManager.persistState();
            this.haStateManager.readState();
            exception = this.timeUtils.sleepForMillis(this.pauseMillis);
        }
    }
}

