/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.thread;

import com.google.inject.assistedinject.Assisted;
import com.seleritycorp.common.base.thread.ExecutorServiceMetricsMBean;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javax.inject.Inject;

public class ExecutorServiceMetrics
implements ExecutorServiceMetricsMBean {
    private final ThreadPoolExecutor executor;
    private final BlockingQueue<Runnable> queue;

    @Inject
    ExecutorServiceMetrics(@Assisted ThreadPoolExecutor executor) {
        this.executor = executor;
        this.queue = executor.getQueue();
    }

    @Override
    public int getActiveThreadCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    @Override
    public int getMinimumPoolSize() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public int getMaximumPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.executor.getCompletedTaskCount();
    }

    public static interface Factory {
        public ExecutorServiceMetrics create(ThreadPoolExecutor var1);
    }
}

