/*
 * Decompiled with CFR 0.152.
 */
package com.github.rzymek.opczip.reader.skipping;

import java.util.Arrays;

class Signature {
    final byte[] bytes;

    Signature(byte[] bytes) {
        this.bytes = bytes;
    }

    public boolean matchesStartOf(byte[] buf) {
        return Arrays.equals(Arrays.copyOf(buf, this.bytes.length), this.bytes);
    }

    public int length() {
        return this.bytes.length;
    }

    public String toString() {
        return Signature.toString(this.bytes, this.bytes.length);
    }

    public static String toString(byte[] buf, int len) {
        StringBuilder s = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            byte b = buf[i];
            char c = (char)b;
            if (Character.isISOControl(c)) {
                s.append('\\').append(String.format("%02d", (short)c));
                continue;
            }
            s.append(c);
        }
        return s.toString();
    }

    public byte at(int index) {
        return this.bytes[index];
    }
}

