/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpHeaders;

public final class FeignUtils {
    private FeignUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    static HttpHeaders getHttpHeaders(Map<String, Collection<String>> headers) {
        HttpHeaders httpHeaders = new HttpHeaders();
        for (Map.Entry<String, Collection<String>> entry : headers.entrySet()) {
            httpHeaders.put(entry.getKey(), new ArrayList<String>(entry.getValue()));
        }
        return httpHeaders;
    }

    static Map<String, Collection<String>> getHeaders(HttpHeaders httpHeaders) {
        LinkedHashMap<String, Collection<String>> headers = new LinkedHashMap<String, Collection<String>>();
        for (Map.Entry entry : httpHeaders.entrySet()) {
            headers.put((String)entry.getKey(), (Collection<String>)entry.getValue());
        }
        return headers;
    }

    static Collection<String> addTemplateParameter(Collection<String> possiblyNull, String paramName) {
        Collection params = Optional.ofNullable(possiblyNull).map(ArrayList::new).orElse(new ArrayList());
        params.add(String.format("{%s}", paramName));
        return params;
    }
}

