/*
 * Decompiled with CFR 0.152.
 */
package com.acbr.bal;

import com.acbr.ACBrLibBase;
import com.acbr.ACBrSessao;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Paths;

public final class ACBrBAL
extends ACBrLibBase {
    public ACBrBAL() throws Exception {
        File iniFile = Paths.get(System.getProperty("user.dir"), "ACBrLib.ini").toFile();
        if (!iniFile.exists()) {
            iniFile.createNewFile();
        }
        int ret = ACBrBALLib.INSTANCE.BAL_Inicializar(ACBrBAL.toUTF8((String)iniFile.getAbsolutePath()), ACBrBAL.toUTF8((String)""));
        this.checkResult(ret);
    }

    public ACBrBAL(String eArqConfig, String eChaveCrypt) throws Exception {
        int ret = ACBrBALLib.INSTANCE.BAL_Inicializar(ACBrBAL.toUTF8((String)eArqConfig), ACBrBAL.toUTF8((String)eChaveCrypt));
        this.checkResult(ret);
    }

    protected void dispose() throws Exception {
        int ret = ACBrBALLib.INSTANCE.BAL_Finalizar();
        this.checkResult(ret);
    }

    public String nome() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        IntByReference bufferLen = new IntByReference(256);
        int ret = ACBrBALLib.INSTANCE.BAL_Nome(buffer, bufferLen);
        this.checkResult(ret);
        return ACBrBAL.fromUTF8((ByteBuffer)buffer, (int)bufferLen.getValue());
    }

    public String versao() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        IntByReference bufferLen = new IntByReference(256);
        int ret = ACBrBALLib.INSTANCE.BAL_Versao(buffer, bufferLen);
        this.checkResult(ret);
        return ACBrBAL.fromUTF8((ByteBuffer)buffer, (int)bufferLen.getValue());
    }

    public void configLer() throws Exception {
        this.configLer("");
    }

    public void configLer(String eArqConfig) throws Exception {
        int ret = ACBrBALLib.INSTANCE.BAL_ConfigLer(ACBrBAL.toUTF8((String)eArqConfig));
        this.checkResult(ret);
    }

    public void configGravar() throws Exception {
        this.configGravar("");
    }

    public void configGravar(String eArqConfig) throws Exception {
        int ret = ACBrBALLib.INSTANCE.BAL_ConfigGravar(ACBrBAL.toUTF8((String)eArqConfig));
        this.checkResult(ret);
    }

    public String configLerValor(ACBrSessao eSessao, String eChave) throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        IntByReference bufferLen = new IntByReference(256);
        int ret = ACBrBALLib.INSTANCE.BAL_ConfigLerValor(ACBrBAL.toUTF8((String)eSessao.name()), ACBrBAL.toUTF8((String)eChave), buffer, bufferLen);
        this.checkResult(ret);
        return this.processResult(buffer, bufferLen);
    }

    public void configGravarValor(ACBrSessao eSessao, String eChave, Object value) throws Exception {
        int ret = ACBrBALLib.INSTANCE.BAL_ConfigGravarValor(ACBrBAL.toUTF8((String)eSessao.name()), ACBrBAL.toUTF8((String)eChave), ACBrBAL.toUTF8((String)value.toString()));
        this.checkResult(ret);
    }

    public void ativar() throws Exception {
        int ret = ACBrBALLib.INSTANCE.BAL_Ativar();
        this.checkResult(ret);
    }

    public void desativar() throws Exception {
        int ret = ACBrBALLib.INSTANCE.BAL_Desativar();
        this.checkResult(ret);
    }

    public double lePeso(int MillisecTimeOut) throws Exception {
        DoubleByReference peso = new DoubleByReference(256.0);
        int ret = ACBrBALLib.INSTANCE.BAL_LePeso(MillisecTimeOut, peso);
        this.checkResult(ret);
        System.out.println(peso.getValue());
        return peso.getValue();
    }

    public void SolicitarPeso() throws Exception {
        int ret = ACBrBALLib.INSTANCE.BAL_SolicitarPeso();
        this.checkResult(ret);
    }

    public double ultimoPesoLido() throws Exception {
        DoubleByReference peso = new DoubleByReference(256.0);
        int ret = ACBrBALLib.INSTANCE.BAL_UltimoPesoLido(peso);
        this.checkResult(ret);
        return peso.getValue();
    }

    public float interpretarRespostaPeso(ByteBuffer eResposta, double var) throws Exception {
        FloatByReference peso = new FloatByReference(256.0f);
        int ret = ACBrBALLib.INSTANCE.BAL_InterpretarRespostaPeso(eResposta, peso);
        this.checkResult(ret);
        return peso.getValue();
    }

    public void ConfigImportar(String eArqConfig) throws Exception {
        int ret = ACBrBALLib.INSTANCE.BAL_ConfigImportar(eArqConfig);
        this.checkResult(ret);
    }

    public String ConfigExportar() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        IntByReference bufferLen = new IntByReference(256);
        int ret = ACBrBALLib.INSTANCE.BAL_ConfigExportar(buffer, bufferLen);
        this.checkResult(ret);
        return ACBrBAL.fromUTF8((ByteBuffer)buffer, (int)bufferLen.getValue());
    }

    protected void UltimoRetorno(ByteBuffer buffer, IntByReference bufferLen) {
        ACBrBALLib.INSTANCE.BAL_UltimoRetorno(buffer, bufferLen);
    }

    private static interface ACBrBALLib
    extends Library {
        public static final String JNA_LIBRARY_NAME = LibraryLoader.access$000();
        public static final ACBrBALLib INSTANCE = LibraryLoader.getInstance();

        public int BAL_Inicializar(String var1, String var2);

        public int BAL_Finalizar();

        public int BAL_Nome(ByteBuffer var1, IntByReference var2);

        public int BAL_Versao(ByteBuffer var1, IntByReference var2);

        public int BAL_UltimoRetorno(ByteBuffer var1, IntByReference var2);

        public int BAL_ConfigImportar(String var1);

        public int BAL_ConfigExportar(ByteBuffer var1, IntByReference var2);

        public int BAL_ConfigLer(String var1);

        public int BAL_ConfigGravar(String var1);

        public int BAL_ConfigLerValor(String var1, String var2, ByteBuffer var3, IntByReference var4);

        public int BAL_ConfigGravarValor(String var1, String var2, String var3);

        public int BAL_Ativar();

        public int BAL_Desativar();

        public int BAL_LePeso(int var1, DoubleByReference var2);

        public int BAL_SolicitarPeso();

        public int BAL_UltimoPesoLido(DoubleByReference var1);

        public int BAL_InterpretarRespostaPeso(ByteBuffer var1, FloatByReference var2);

        public static class LibraryLoader {
            private static String library = "";
            private static ACBrBALLib instance = null;

            private static String getLibraryName() {
                if (library.isEmpty()) {
                    library = Platform.isWindows() ? (Platform.is64Bit() ? "ACBrBAL64" : "ACBrBAL32") : (Platform.is64Bit() ? "acbrbal64" : "acbrbal32");
                }
                return library;
            }

            public static ACBrBALLib getInstance() {
                if (instance == null) {
                    instance = (ACBrBALLib)Native.synchronizedLibrary((Library)Native.load((String)JNA_LIBRARY_NAME, ACBrBALLib.class));
                }
                return instance;
            }

            static /* synthetic */ String access$000() {
                return LibraryLoader.getLibraryName();
            }
        }
    }
}

