/*
 * Decompiled with CFR 0.152.
 */
package com.acbr;

import com.acbr.ACBrSessao;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class ACBrLibBase
implements AutoCloseable {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected static final int STR_BUFFER_LEN = 256;
    private Pointer libHandler;

    protected Pointer getHandle() {
        return this.libHandler;
    }

    protected void setHandle(Pointer value) {
        this.libHandler = value;
    }

    @Override
    public void close() throws Exception {
        if (this.libHandler != null) {
            this.dispose();
        }
        this.libHandler = null;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.libHandler != null) {
                this.dispose();
            }
            this.libHandler = null;
        }
        finally {
            super.finalize();
        }
    }

    public abstract String configLerValor(ACBrSessao var1, String var2) throws Exception;

    public abstract void configGravarValor(ACBrSessao var1, String var2, Object var3) throws Exception;

    protected abstract void dispose() throws Exception;

    protected abstract void UltimoRetorno(ByteBuffer var1, IntByReference var2);

    protected static String toUTF8(String value) {
        return new String(value.getBytes(UTF8));
    }

    protected static String fromUTF8(ByteBuffer buffer, int len) {
        return new String(buffer.array(), 0, len, UTF8);
    }

    protected static String toUTF8(Boolean value) {
        return ACBrLibBase.toUTF8(value != false ? "1" : "0");
    }

    protected static String toUTF8(int value) {
        return ACBrLibBase.toUTF8(Integer.toString(value));
    }

    protected static String toUTF8(char[] value) {
        return ACBrLibBase.toUTF8(new String(value));
    }

    protected static String fromUTF8(ByteBuffer buffer, IntByReference len) {
        byte[] array = buffer.array();
        return new String(array, 0, len.getValue(), UTF8);
    }

    protected void checkResult(int result) throws Exception {
        if (result == 0) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(256);
        IntByReference bufferLen = new IntByReference(256);
        this.UltimoRetorno(buffer, bufferLen);
        throw new Exception(this.processResult(buffer, bufferLen));
    }

    protected String processResult(ByteBuffer buffer, IntByReference bufferLen) {
        int bLen = bufferLen.getValue();
        if (bLen > 256) {
            int tamanhoBuffer = (int)Math.round((double)bLen * 1.3);
            ByteBuffer nBuffer = ByteBuffer.allocate(tamanhoBuffer);
            IntByReference nBufferLen = new IntByReference(tamanhoBuffer);
            this.UltimoRetorno(nBuffer, nBufferLen);
            return ACBrLibBase.fromUTF8(nBuffer, nBufferLen);
        }
        return ACBrLibBase.fromUTF8(buffer, bufferLen);
    }
}

