/*
 * Decompiled with CFR 0.152.
 */
package com.acbr.serial;

import com.acbr.serial.SerialHandShake;
import com.acbr.serial.SerialParity;
import com.acbr.serial.SerialStopBytes;

public class ACBrDevice {
    private String porta = "";
    private int baud = 9600;
    private int dataBits = 8;
    private SerialParity parity = SerialParity.None;
    private SerialStopBytes stopBits = SerialStopBytes.One;
    private SerialHandShake handShake = SerialHandShake.Nenhum;
    private boolean hardFlow = false;
    private boolean softFlow = false;
    private int timeOut;
    private int maxBandwidth = 0;
    private int sendBytesCount = 0;
    private int sendBytesInterval = 0;

    public ACBrDevice() {
    }

    public ACBrDevice(String deviceParams) {
        this();
        if (deviceParams.isEmpty()) {
            return;
        }
        this.LerDeviceParams(deviceParams);
    }

    public void LerDeviceParams(String deviceParams) {
        String[] dParams;
        block24: for (String dParam : dParams = deviceParams.split("")) {
            String[] parameters = dParam.toUpperCase().split("=");
            switch (parameters[0]) {
                case "BAUD": {
                    this.baud = Integer.parseInt(parameters[1]);
                    continue block24;
                }
                case "DATA": {
                    this.dataBits = Integer.parseInt(parameters[1]);
                    continue block24;
                }
                case "PARITY": {
                    this.parity = SerialParity.valueOf(parameters[1].charAt(0));
                    continue block24;
                }
                case "STOP": {
                    this.stopBits = parameters[1].trim() == "1" ? SerialStopBytes.One : (parameters[1].trim() == "1,5" ? SerialStopBytes.OnePointFive : SerialStopBytes.Two);
                    continue block24;
                }
                case "HARDFLOW": {
                    this.hardFlow = true;
                    continue block24;
                }
                case "SOFTFLOW": {
                    this.softFlow = true;
                    continue block24;
                }
                case "HANDSHAKE": {
                    this.handShake = parameters[1].trim() == "XON/XOFF" ? SerialHandShake.XON_XOFF : (parameters[1].trim() == "DTR/DSR" ? SerialHandShake.DTR_DSR : (parameters[1].trim() == "RTS/CTS" ? SerialHandShake.RTS_CTS : SerialHandShake.Nenhum));
                    continue block24;
                }
                case "MAXBANDWIDTH": {
                    this.maxBandwidth = Integer.parseInt(parameters[1]);
                    continue block24;
                }
                case "SENDBYTESCOUNT": {
                    this.sendBytesCount = Integer.parseInt(parameters[1]);
                    continue block24;
                }
                case "SENDBYTESINTERVAL": {
                    this.sendBytesInterval = Integer.parseInt(parameters[1]);
                    continue block24;
                }
            }
        }
    }

    public String toString() {
        StringBuilder parmsString = new StringBuilder();
        parmsString.append(String.format("BAUD=%1$d ", this.baud));
        parmsString.append(String.format("DATA=%1$d ", this.dataBits));
        parmsString.append(String.format("PARITY=%1s ", Character.valueOf(this.parity.asChar())));
        parmsString.append(String.format("STOP=%1s", this.stopBits == SerialStopBytes.One ? "1" : (this.stopBits == SerialStopBytes.OnePointFive ? "1,5" : "2")));
        parmsString.append(String.format("HANDSHAKE=%1s", this.handShake == SerialHandShake.XON_XOFF ? "XON/XOFF" : (this.handShake == SerialHandShake.DTR_DSR ? "DTR/DSR" : (this.handShake == SerialHandShake.RTS_CTS ? "RTS/CTS" : ""))));
        if (this.hardFlow) {
            parmsString.append("HARDFLOW ");
        }
        if (this.softFlow) {
            parmsString.append("SOFTFLOW ");
        }
        parmsString.append(String.format("MAXBANDWIDTH=%1$d ", this.maxBandwidth));
        parmsString.append(String.format("SENDBYTESCOUNT=%1$d ", this.sendBytesCount));
        parmsString.append(String.format("SENDBYTESINTERVAL={%1$d ", this.sendBytesInterval));
        return parmsString.toString().trim();
    }

    public String getPorta() {
        return this.porta;
    }

    public void setPorta(String porta) {
        this.porta = porta;
    }

    public int getBaud() {
        return this.baud;
    }

    public void setBaud(int baud) {
        this.baud = baud;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public void setDataBits(int dataBits) {
        this.dataBits = dataBits;
    }

    public SerialParity getParity() {
        return this.parity;
    }

    public void setParity(SerialParity parity) {
        this.parity = parity;
    }

    public SerialStopBytes getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(SerialStopBytes stopBits) {
        this.stopBits = stopBits;
    }

    public SerialHandShake getHandShake() {
        return this.handShake;
    }

    public void setHandShake(SerialHandShake handShake) {
        this.handShake = handShake;
    }

    public boolean isHardFlow() {
        return this.hardFlow;
    }

    public void setHardFlow(boolean hardFlow) {
        this.hardFlow = hardFlow;
    }

    public boolean isSoftFlow() {
        return this.softFlow;
    }

    public void setSoftFlow(boolean softFlow) {
        this.softFlow = softFlow;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public int getMaxBandwidth() {
        return this.maxBandwidth;
    }

    public void setMaxBandwidth(int maxBandwidth) {
        this.maxBandwidth = maxBandwidth;
    }

    public int getSendBytesCount() {
        return this.sendBytesCount;
    }

    public void setSendBytesCount(int sendBytesCount) {
        this.sendBytesCount = sendBytesCount;
    }

    public int getSendBytesInterval() {
        return this.sendBytesInterval;
    }

    public void setSendBytesInterval(int sendBytesInterval) {
        this.sendBytesInterval = sendBytesInterval;
    }
}

