/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.application;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.seleritycorp.common.base.application.Application;
import com.seleritycorp.common.base.application.CommandLineArguments;
import com.seleritycorp.common.base.inject.InjectorFactory;
import com.seleritycorp.common.base.state.AppState;
import com.seleritycorp.common.base.state.StateManager;
import javax.inject.Inject;

public class ApplicationRunner {
    private final Application application;
    private final StateManager stateManager;

    @Inject
    ApplicationRunner(Application application, StateManager stateManager) {
        this.application = application;
        this.stateManager = stateManager;
    }

    public synchronized void run() throws Exception {
        this.application.init();
        this.stateManager.setMainAppState(AppState.READY);
        this.application.run();
        this.stateManager.setMainAppState(AppState.FAULTY);
        this.application.shutdown();
    }

    public static void run(final String[] args, AbstractModule ... modules) throws Exception {
        for (AbstractModule module : modules) {
            InjectorFactory.register(module);
        }
        InjectorFactory.register(new AbstractModule(){

            protected void configure() {
                this.bind(String[].class).annotatedWith(CommandLineArguments.class).toInstance((Object)args);
            }
        });
        Injector injector = InjectorFactory.getInjector();
        ApplicationRunner runner = (ApplicationRunner)injector.getInstance(ApplicationRunner.class);
        runner.run();
        System.exit(0);
    }

    static interface Factory {
        public ApplicationRunner create(String[] var1);
    }
}

