/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.application;

import com.seleritycorp.common.base.application.Application;
import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public abstract class NonBlockingApplication
extends Application {
    private static final Log log = LogFactory.getLog(NonBlockingApplication.class);

    public abstract void runNonBlocking() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT", "WA_NOT_IN_LOOP"}, justification="Keeping the main thread alive (to avoid early exit) until user interruptions occurs")
    public final void run() throws Exception {
        this.runNonBlocking();
        NonBlockingApplication nonBlockingApplication = this;
        synchronized (nonBlockingApplication) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                log.info("Main method interrupted", e);
            }
        }
    }
}

