/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.cache.callable;

import com.google.inject.assistedinject.Assisted;
import com.seleritycorp.common.base.cache.callable.StaticTrackingCallable;
import java.util.concurrent.Callable;
import javax.inject.Inject;

public class ThreadLocalStaticTrackingCallable<T>
implements Callable<T> {
    private final ThreadLocal<StaticTrackingCallable<T>> callables;

    @Inject
    public ThreadLocalStaticTrackingCallable(final StaticTrackingCallable.Factory factory, final @Assisted T callResult) {
        this.callables = new ThreadLocal<StaticTrackingCallable<T>>(){

            @Override
            protected StaticTrackingCallable<T> initialValue() {
                return factory.create(callResult);
            }
        };
    }

    public void reset() {
        this.callables.get().reset();
    }

    @Override
    public T call() {
        return this.callables.get().call();
    }

    public boolean isUncalled() {
        return this.callables.get().isUncalled();
    }

    public static class Factory {
        private final StaticTrackingCallable.Factory factory;

        @Inject
        Factory(StaticTrackingCallable.Factory factory) {
            this.factory = factory;
        }

        public <T> ThreadLocalStaticTrackingCallable<T> create(T callResult) {
            return new ThreadLocalStaticTrackingCallable<T>(this.factory, callResult);
        }
    }
}

