/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.config;

import com.seleritycorp.common.base.config.ApplicationPath;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.config.ConfigImpl;
import com.seleritycorp.common.base.config.ConfigUtils;
import com.seleritycorp.common.base.config.DefaultConfig;
import com.seleritycorp.common.base.config.EnforcedDefaultConfig;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Provider;

public class ApplicationConfigProvider
implements Provider<Config> {
    private static final String JSON_NAME = "application.json";
    private static final String PROPERTIES_NAME = "application.properties";
    private final Path applicationPath;

    @Inject
    ApplicationConfigProvider(@ApplicationPath Path applicationPath) {
        this.applicationPath = applicationPath;
    }

    public Config get() {
        DefaultConfig defaultConfig = new DefaultConfig();
        EnforcedDefaultConfig enforcedConfig = new EnforcedDefaultConfig();
        enforcedConfig.setParent(defaultConfig);
        String pathStr = enforcedConfig.get("paths.confAnsiblized");
        Path confAnsiblizedPath = this.applicationPath.resolve(pathStr);
        ConfigImpl parent = defaultConfig;
        ConfigImpl config = ConfigUtils.load(confAnsiblizedPath.resolve(JSON_NAME));
        config.setParent(defaultConfig);
        parent = config;
        config = ConfigUtils.load(confAnsiblizedPath.resolve(PROPERTIES_NAME));
        config.setParent(parent);
        pathStr = enforcedConfig.get("paths.conf");
        Path confPath = this.applicationPath.resolve(pathStr);
        parent = config;
        config = ConfigUtils.load(confPath.resolve(JSON_NAME));
        config.setParent(parent);
        parent = config;
        config = ConfigUtils.load(confPath.resolve(PROPERTIES_NAME));
        config.setParent(parent);
        parent = config;
        config = enforcedConfig;
        config.setParent(parent);
        return config;
    }
}

