/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.config;

import com.seleritycorp.common.base.config.ApplicationConfig;
import com.seleritycorp.common.base.config.ApplicationPath;
import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ApplicationPaths {
    private static final Log log = LogFactory.getLog(ApplicationPaths.class);
    private final Path basePath;
    private final Path confPath;
    private final Path confAnsiblizedPath;
    private final Path dataPath;
    private final Path dataStatePath;

    @Inject
    ApplicationPaths(@ApplicationPath Path basePath, @ApplicationConfig Config config) {
        this.basePath = basePath;
        this.confPath = this.initPath(basePath, config, "paths.conf");
        this.confAnsiblizedPath = this.initPath(basePath, config, "paths.confAnsiblized");
        this.dataPath = this.initPath(basePath, config, "paths.data");
        this.dataStatePath = this.initPath(this.dataPath, config, "paths.dataState");
    }

    private Path initPath(Path base, Config config, String key) {
        Path ret = base.resolve(config.get(key));
        try {
            if (!Files.isDirectory(ret, new LinkOption[0])) {
                Files.createDirectories(ret, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            log.error("Could not create directory " + ret.toString() + " for " + key, e);
        }
        return ret;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public Path getConfPath() {
        return this.confPath;
    }

    public Path getConfAnsiblizedPath() {
        return this.confAnsiblizedPath;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    public Path getDataStatePath() {
        return this.dataStatePath;
    }
}

