/*
 * Decompiled with CFR 0.152.
 */
package com.seleritycorp.common.base.config;

import com.seleritycorp.common.base.config.Config;
import com.seleritycorp.common.base.config.ConfigBase;
import com.seleritycorp.common.base.logging.Log;
import com.seleritycorp.common.base.logging.LogFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ConfigImpl
implements Config {
    private static final Log log = LogFactory.getLog(ConfigImpl.class);
    ConcurrentMap<String, String> values = new ConcurrentHashMap<String, String>();
    ConfigBase parent = null;

    @Override
    public String get(String key) {
        String ret = (String)this.values.get(key);
        if (ret == null && this.parent != null) {
            ret = this.parent.get(key);
        }
        return ret;
    }

    @Override
    public String get(String key, String defaultValue) {
        String ret = this.get(key);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public void setParent(ConfigBase parent) {
        this.parent = parent;
    }

    @Override
    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String value = this.get(key);
        int ret = defaultValue;
        if (value != null) {
            try {
                ret = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                try {
                    double retDouble = this.getDouble(key, Double.NaN, false);
                    if (!Double.isNaN(retDouble)) {
                        ret = (int)retDouble;
                    }
                }
                catch (NumberFormatException e2) {
                    log.error("Value at \"" + key + "\" is not null, but  does not parse to an integer", e);
                }
            }
        }
        return ret;
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        String value = this.get(key);
        long ret = defaultValue;
        if (value != null) {
            try {
                ret = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                try {
                    double retDouble = this.getDouble(key, Double.NaN, false);
                    if (!Double.isNaN(retDouble)) {
                        ret = (long)retDouble;
                    }
                }
                catch (NumberFormatException e2) {
                    log.error("Value at \"" + key + "\" is not null, but  does not parse to a long", e);
                }
            }
        }
        return ret;
    }

    @Override
    public float getFloat(String key) {
        return this.getFloat(key, Float.NaN);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        String value = this.get(key);
        float ret = defaultValue;
        if (value != null) {
            try {
                ret = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                log.error("Value at \"" + key + "\" is not null, but  does not parse to a float", e);
            }
        }
        return ret;
    }

    @Override
    public double getDouble(String key) {
        return this.getDouble(key, Double.NaN);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, defaultValue, true);
    }

    public double getDouble(String key, double defaultValue, boolean doLog) {
        double ret;
        block3: {
            String value = this.get(key);
            ret = defaultValue;
            if (value != null) {
                try {
                    ret = Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    if (!doLog) break block3;
                    log.error("Value at \"" + key + "\" is not null, but  does not parse to a double", e);
                }
            }
        }
        return ret;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        boolean ret = defaultValue;
        if (value != null) {
            double doubleValue;
            boolean bl = ret = "true".compareToIgnoreCase(value.trim()) == 0;
            if (!ret && !Double.isNaN(doubleValue = this.getDouble(key, Double.NaN, false))) {
                ret = doubleValue != 0.0;
            }
        }
        return ret;
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> clazz, String key) {
        return this.getEnum(clazz, key, null);
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> clazz, String key, T defaultValue) {
        T ret = null;
        String value = this.get(key);
        if (value == null) {
            ret = defaultValue;
        } else {
            try {
                ret = Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                log.error("Value at \"" + key + "\" does not parse to a " + clazz + ".", e);
                ret = defaultValue;
            }
        }
        return ret;
    }

    @Override
    public long getDurationMillis(String key) {
        return this.getDurationMillis(key, 0L);
    }

    @Override
    public long getDurationMillis(String key, long defaultDuration) {
        return this.getDurationMillis(key, defaultDuration, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getDurationMillis(String key, long defaultDuration, TimeUnit defaultUnit) {
        long ret = 0L;
        long duration = this.getLong(key, defaultDuration);
        TimeUnit unit = this.getEnum(TimeUnit.class, key + "Unit", defaultUnit);
        ret = unit == null ? 0L : unit.toMillis(duration);
        return ret;
    }

    @Override
    public long getDurationSeconds(String key) {
        return this.getDurationSeconds(key, 0L);
    }

    @Override
    public long getDurationSeconds(String key, long defaultDuration) {
        return this.getDurationSeconds(key, defaultDuration, TimeUnit.SECONDS);
    }

    @Override
    public long getDurationSeconds(String key, long defaultDuration, TimeUnit defaultUnit) {
        long ret = 0L;
        long duration = this.getLong(key, defaultDuration);
        TimeUnit unit = this.getEnum(TimeUnit.class, key + "Unit", defaultUnit);
        ret = unit == null ? 0L : unit.toSeconds(duration);
        return ret;
    }

    public void set(String key, @Nullable String value) {
        if (value == null) {
            this.values.remove(key);
        } else {
            this.values.put(key, value);
        }
    }
}

